/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.graphics.Image;

class GraphLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private final DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private RevCommit lastCommit;
    private PersonIdent lastAuthor;
    private PersonIdent lastCommitter;

    GraphLabelProvider() {
    }

    public String getColumnText(Object element, int columnIndex) {
        PersonIdent committer;
        PersonIdent author;
        RevCommit c = (RevCommit)element;
        if (columnIndex == 0) {
            return c.getShortMessage();
        }
        if (columnIndex == 3) {
            return String.valueOf(c.getId().abbreviate(8).name()) + "...";
        }
        if ((columnIndex == 1 || columnIndex == 2) && (author = this.authorOf(c)) != null) {
            switch (columnIndex) {
                case 1: {
                    return String.valueOf(author.getName()) + " <" + author.getEmailAddress() + ">";
                }
                case 2: {
                    return this.fmt.format(author.getWhen());
                }
            }
        }
        if (columnIndex == 4 && (committer = this.committerOf(c)) != null) {
            return String.valueOf(committer.getName()) + " <" + committer.getEmailAddress() + ">";
        }
        return "";
    }

    private PersonIdent authorOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastAuthor;
    }

    private PersonIdent committerOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastCommitter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

