/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.jgit.lib.Repository;

public class HistoryPageInput {
    private final IResource[] list;
    private final File[] files;
    private final Repository repo;
    private final Object singleFile;
    private final Object singleItem;

    public HistoryPageInput(Repository repository, IResource[] resourceItems) {
        this.repo = repository;
        this.list = resourceItems;
        if (resourceItems.length == 1) {
            this.singleItem = resourceItems[0];
            this.singleFile = resourceItems[0].getType() == 1 ? resourceItems[0] : null;
        } else {
            this.singleItem = null;
            this.singleFile = null;
        }
        this.files = null;
    }

    public HistoryPageInput(Repository repository, File[] fileItems) {
        this.repo = repository;
        this.list = null;
        if (fileItems.length == 1) {
            this.singleItem = fileItems[0];
            this.singleFile = fileItems[0].isFile();
        } else {
            this.singleItem = null;
            this.singleFile = null;
        }
        this.files = fileItems;
    }

    public HistoryPageInput(Repository repository) {
        this.repo = repository;
        this.list = null;
        this.singleFile = null;
        this.singleItem = null;
        this.files = null;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public IResource[] getItems() {
        return this.list;
    }

    public File[] getFileList() {
        return this.files;
    }

    public Object getSingleFile() {
        return this.singleFile;
    }

    public Object getSingleItem() {
        return this.singleItem;
    }

    public boolean isSingleFile() {
        return this.singleFile != null;
    }
}

