/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.AbstractPlotRenderer;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.themes.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SWTPlotRenderer
extends AbstractPlotRenderer<SWTCommitList.SWTLane, Color> {
    private final Color sys_blue;
    private final Color sys_black;
    private final Color sys_gray;
    private final Color sys_darkblue;
    private final Color sys_yellow;
    private final Color sys_green;
    private final Color sys_white;
    GC g;
    int cellX;
    int cellY;
    Color cellFG;
    Color cellBG;

    SWTPlotRenderer(Display d) {
        this.sys_blue = d.getSystemColor(9);
        this.sys_black = d.getSystemColor(2);
        this.sys_gray = d.getSystemColor(15);
        this.sys_darkblue = d.getSystemColor(10);
        this.sys_yellow = d.getSystemColor(7);
        this.sys_green = d.getSystemColor(5);
        this.sys_white = d.getSystemColor(1);
    }

    void paint(Event event) {
        this.g = event.gc;
        this.cellX = event.x;
        this.cellY = event.y;
        this.cellFG = this.g.getForeground();
        this.cellBG = this.g.getBackground();
        TableItem ti = (TableItem)event.item;
        this.paintCommit((PlotCommit)ti.getData(), event.height);
    }

    protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
        this.g.setForeground(color);
        this.g.setLineWidth(width);
        this.g.drawLine(this.cellX + x1, this.cellY + y1, this.cellX + x2, this.cellY + y2);
    }

    protected void drawCommitDot(int x, int y, int w, int h) {
        this.g.setBackground(this.sys_blue);
        this.g.fillOval(this.cellX + x, this.cellY + y, w, h);
        this.g.setForeground(this.sys_darkblue);
        this.g.setLineWidth(2);
        this.g.drawOval(this.cellX + x + 1, this.cellY + y + 1, w - 2, h - 2);
        this.g.setForeground(this.sys_black);
        this.g.setLineWidth(1);
        this.g.drawOval(this.cellX + x, this.cellY + y, w, h);
    }

    protected void drawBoundaryDot(int x, int y, int w, int h) {
        this.g.setForeground(this.sys_gray);
        this.g.setBackground(this.cellBG);
        this.g.setLineWidth(1);
        this.g.fillOval(this.cellX + x, this.cellY + y, w, h);
        this.g.drawOval(this.cellX + x, this.cellY + y, w, h);
    }

    protected void drawText(String msg, int x, int y) {
        Point textsz = this.g.textExtent(msg);
        int texty = (y * 2 - textsz.y) / 2;
        this.g.setForeground(this.cellFG);
        this.g.setBackground(this.cellBG);
        this.g.drawString(msg, this.cellX + x, this.cellY + texty, true);
    }

    protected int drawLabel(int x, int y, Ref ref) {
        String txt;
        String name = ref.getName();
        if (name.startsWith("refs/heads/")) {
            this.g.setBackground(this.sys_green);
            txt = name.substring("refs/heads/".length());
        } else if (name.startsWith("refs/remotes/")) {
            this.g.setBackground(this.sys_gray);
            txt = name.substring("refs/remotes/".length());
        } else if (name.startsWith("refs/tags/")) {
            this.g.setBackground(this.sys_yellow);
            txt = name.substring("refs/tags/".length());
        } else {
            this.g.setBackground(this.sys_white);
            txt = name.startsWith("refs/") ? name.substring("refs/".length()) : name;
        }
        Color peeledColor = null;
        if (ref.getPeeledObjectId() == null || !ref.getPeeledObjectId().equals((AnyObjectId)ref.getObjectId())) {
            peeledColor = new Color(this.g.getDevice(), ColorUtil.blend((RGB)this.g.getBackground().getRGB(), (RGB)this.sys_white.getRGB()));
            this.g.setBackground(peeledColor);
        }
        if (txt.length() > 12) {
            txt = String.valueOf(txt.substring(0, 11)) + "\u2026";
        }
        Point textsz = this.g.stringExtent(txt);
        int arc = textsz.y / 2;
        int texty = (y * 2 - textsz.y) / 2;
        this.g.fillRoundRectangle(this.cellX + x + 1, this.cellY + texty - 1, textsz.x + 3, textsz.y + 1, arc, arc);
        this.g.setForeground(this.sys_black);
        this.g.drawString(txt, this.cellX + x + 2, this.cellY + texty, true);
        this.g.setLineWidth(2);
        this.g.setAlpha(128);
        this.g.setForeground(this.sys_gray);
        this.g.drawRoundRectangle(this.cellX + x, this.cellY + texty - 2, textsz.x + 5, textsz.y + 3, arc, arc);
        this.g.setLineWidth(2);
        this.g.setForeground(this.sys_black);
        this.g.drawRoundRectangle(this.cellX + x + 1, this.cellY + texty - 1, textsz.x + 3, textsz.y + 1, arc, arc);
        this.g.setAlpha(255);
        if (peeledColor != null) {
            peeledColor.dispose();
        }
        return 8 + textsz.x;
    }

    protected Color laneColor(SWTCommitList.SWTLane myLane) {
        return myLane != null ? myLane.color : this.sys_black;
    }
}

