/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.util.List;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AmbiguousBranchDialog
extends MessageDialog {
    private final List<RefNode> nodes;
    private TableViewer branchesList;
    private RefNode selected;

    AmbiguousBranchDialog(Shell parentShell, List<RefNode> nodes, String title, String message) {
        super(parentShell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.nodes = nodes;
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new FillLayout());
        this.branchesList = new TableViewer(area, 2820);
        this.branchesList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.branchesList.setLabelProvider((IBaseLabelProvider)new BranchLabelProvider());
        this.branchesList.setInput(this.nodes);
        this.branchesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AmbiguousBranchDialog.this.getButton(0).setEnabled(!event.getSelection().isEmpty());
            }
        });
        return area;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.selected = (RefNode)((IStructuredSelection)this.branchesList.getSelection()).getFirstElement();
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public RefNode getSelectedNode() {
        return this.selected;
    }

    static final class BranchLabelProvider
    extends LabelProvider {
        BranchLabelProvider() {
        }

        public String getText(Object element) {
            RefNode refNode = (RefNode)element;
            return ((Ref)refNode.getObject()).getName();
        }

        public Image getImage(Object element) {
            return RepositoryTreeNodeType.REF.getIcon();
        }
    }
}

