/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.util.Iterator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommanndHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareVersionsInTreeHandler
extends AbstractHistoryCommanndHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(this.getPage());
        if (selection.size() == 2) {
            Iterator it = selection.iterator();
            RevCommit commit1 = (RevCommit)it.next();
            RevCommit commit2 = (RevCommit)it.next();
            Object input = this.getPage().getInputInternal().getSingleItem();
            Repository repository = this.getPage().getInputInternal().getRepository();
            if (input instanceof IFile) {
                IFile resource = (IFile)input;
                RepositoryMapping map = RepositoryMapping.getMapping((IResource)resource);
                String gitPath = map.getRepoRelativePath((IResource)resource);
                ITypedElement base = CompareUtils.getFileRevisionTypedElement(gitPath, commit1, map.getRepository());
                ITypedElement next = CompareUtils.getFileRevisionTypedElement(gitPath, commit2, map.getRepository());
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
                this.openInCompare(event, (CompareEditorInput)in);
            } else if (input instanceof File) {
                File fileInput = (File)input;
                Repository repo = this.getRepository(event);
                String gitPath = this.getRepoRelativePath(repo, fileInput);
                ITypedElement base = CompareUtils.getFileRevisionTypedElement(gitPath, commit1, repo);
                ITypedElement next = CompareUtils.getFileRevisionTypedElement(gitPath, commit2, repo);
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
                this.openInCompare(event, (CompareEditorInput)in);
            } else if (input instanceof IResource) {
                try {
                    CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                    view.setInput(new IResource[]{(IResource)input}, commit1.getId().name(), commit2.getId().name());
                }
                catch (PartInitException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            } else if (input == null) {
                try {
                    CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                    view.setInput(repository, commit1.getId().name(), commit2.getId().name());
                }
                catch (PartInitException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        return this.getSelection(page).size() == 2;
    }
}

