/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.history.GitCreatePatchWizard;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommanndHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class CreatePatchHandler
extends AbstractHistoryCommanndHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(this.getPage());
        if (selection.size() == 1) {
            RevCommit commit = (RevCommit)selection.getFirstElement();
            Repository repo = this.getRepository(event);
            TreeWalk fileWalker = new TreeWalk(repo);
            fileWalker.setRecursive(true);
            fileWalker.setFilter(TreeFilter.ANY_DIFF);
            GitCreatePatchWizard.run(this.getPart(event), commit, fileWalker, repo);
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection selection = this.getSelection(page);
        if (selection.size() != 1) {
            return false;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        return commit.getParentCount() == 1;
    }
}

