/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.internal.dialogs.CreateTagDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommanndHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateTagOnCommitHandler
extends AbstractHistoryCommanndHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlotCommit commit = (PlotCommit)this.getSelection(this.getPage()).getFirstElement();
        Repository repo = this.getRepository(event);
        CreateTagDialog dialog = new CreateTagDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), commit.getId(), repo);
        if (dialog.open() != 0) {
            return null;
        }
        TagBuilder tag = new TagBuilder();
        PersonIdent personIdent = new PersonIdent(repo);
        String tagName = dialog.getTagName();
        tag.setTag(tagName);
        tag.setTagger(personIdent);
        tag.setMessage(dialog.getTagMessage());
        tag.setObjectId((RevObject)commit);
        try {
            new TagOperation(repo, tag, dialog.shouldOverWriteTag()).execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection sel = this.getSelection(page);
        return sel.size() == 1 && sel.getFirstElement() instanceof RevCommit;
    }
}

