/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommanndHandler;
import org.eclipse.egit.ui.internal.job.JobUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ResetHandler
extends AbstractHistoryCommanndHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ResetOperation.ResetType resetType;
        Repository repo = this.getRepository(event);
        RevCommit commit = (RevCommit)this.getSelection(this.getPage()).getFirstElement();
        String type = event.getParameter("org.eclipse.egit.ui.history.ResetMode");
        if (type.equals("Hard")) {
            resetType = ResetOperation.ResetType.HARD;
        } else if (type.equals("Mixed")) {
            resetType = ResetOperation.ResetType.MIXED;
        } else if (type.equals("Soft")) {
            resetType = ResetOperation.ResetType.SOFT;
        } else {
            throw new ExecutionException("Could not determine the reset type");
        }
        String jobName = "Reset";
        switch (resetType) {
            case HARD: {
                if (!MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)UIText.ResetTargetSelectionDialog_ResetQuestion, (String)UIText.ResetTargetSelectionDialog_ResetConfirmQuestion)) {
                    return null;
                }
                jobName = UIText.HardResetToRevisionAction_hardReset;
                break;
            }
            case SOFT: {
                jobName = UIText.SoftResetToRevisionAction_softReset;
                break;
            }
            case MIXED: {
                jobName = UIText.MixedResetToRevisionAction_mixedReset;
            }
        }
        ResetOperation operation = new ResetOperation(repo, commit.getName(), resetType);
        JobUtil.scheduleUserJob((IEGitOperation)operation, jobName, JobFamilies.RESET);
        return null;
    }
}

