/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.preferences.AddConfigEntryDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class ConfigurationEditorComponent {
    private static final String DOT = ".";
    private final StoredConfig editableConfig;
    private final IShellProvider shellProvider;
    private final Composite parent;
    private final boolean useDialogFont;
    private Text valueText;
    private Button changeValue;
    private Button addValue;
    private Button remove;
    private Button deleteValue;
    private TreeViewer tv;
    private Text location;

    public ConfigurationEditorComponent(Composite parent, StoredConfig config, boolean useDialogFont) {
        this.editableConfig = config;
        this.shellProvider = new SameShellProvider((Control)parent);
        this.parent = parent;
        this.useDialogFont = useDialogFont;
    }

    public void save() throws IOException {
        this.editableConfig.save();
        this.setDirty(false);
        this.initControlsFromConfig();
    }

    public void restore() throws IOException {
        try {
            this.editableConfig.load();
            this.tv.refresh();
        }
        catch (ConfigInvalidException e) {
            throw new IOException(e.getMessage());
        }
        this.initControlsFromConfig();
    }

    public Control createContents() {
        Composite main = new Composite(this.parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        if (this.editableConfig instanceof FileBasedConfig) {
            Composite locationPanel = new Composite(main, 0);
            locationPanel.setLayout((Layout)new GridLayout(3, false));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)locationPanel);
            Label locationLabel = new Label(locationPanel, 0);
            locationLabel.setText(UIText.ConfigurationEditorComponent_ConfigLocationLabel);
            this.location = new Text(locationPanel, 2048);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.location);
            this.location.setEditable(false);
            Button openEditor = new Button(locationPanel, 8);
            openEditor.setText(UIText.ConfigurationEditorComponent_OpenEditorButton);
            openEditor.setToolTipText(UIText.ConfigurationEditorComponent_OpenEditorTooltip);
            openEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(((FileBasedConfig)ConfigurationEditorComponent.this.editableConfig).getFile().getAbsolutePath()));
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileStoreEditorInput(store), (String)"org.eclipse.ui.DefaultTextEditor");
                    }
                    catch (PartInitException ex) {
                        Activator.handleError(ex.getMessage(), ex, true);
                    }
                }
            });
            openEditor.setEnabled(((FileBasedConfig)this.editableConfig).getFile() != null);
        }
        this.tv = new TreeViewer(main, 67588);
        Tree tree = this.tv.getTree();
        GridDataFactory.fillDefaults().hint(100, 60).grab(true, true).applyTo((Control)tree);
        TreeColumn key = new TreeColumn(tree, 0);
        key.setText(UIText.ConfigurationEditorComponent_KeyColumnHeader);
        key.setWidth(150);
        TreeColumn value = new TreeColumn(tree, 0);
        value.setText(UIText.ConfigurationEditorComponent_ValueColumnHeader);
        value.setWidth(250);
        this.tv.setContentProvider((IContentProvider)new ConfigEditorContentProvider());
        Font defaultFont = this.useDialogFont ? JFaceResources.getDialogFont() : JFaceResources.getDefaultFont();
        this.tv.setLabelProvider((IBaseLabelProvider)new ConfigEditorLabelProvider(defaultFont));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        Composite buttonPanel = new Composite(main, 0);
        buttonPanel.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        Button newEntry = new Button(buttonPanel, 8);
        GridDataFactory.fillDefaults().applyTo((Control)newEntry);
        newEntry.setText(UIText.ConfigurationEditorComponent_NewValueButton);
        newEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String suggestedKey;
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Section) {
                    suggestedKey = String.valueOf(((Section)first).name) + ConfigurationEditorComponent.DOT;
                } else if (first instanceof SubSection) {
                    SubSection sub = (SubSection)first;
                    suggestedKey = String.valueOf(sub.parent.name) + ConfigurationEditorComponent.DOT + sub.name + ConfigurationEditorComponent.DOT;
                } else {
                    Entry entry;
                    suggestedKey = first instanceof Entry ? ((entry = (Entry)first).sectionparent != null ? String.valueOf(entry.sectionparent.name) + ConfigurationEditorComponent.DOT : String.valueOf(entry.subsectionparent.parent.name) + ConfigurationEditorComponent.DOT + entry.subsectionparent.name + ConfigurationEditorComponent.DOT) : null;
                }
                AddConfigEntryDialog dlg = new AddConfigEntryDialog(ConfigurationEditorComponent.this.getShell(), (Config)ConfigurationEditorComponent.this.editableConfig, suggestedKey);
                if (dlg.open() == 0) {
                    StringTokenizer st = new StringTokenizer(dlg.getKey(), ConfigurationEditorComponent.DOT);
                    if (st.countTokens() == 2) {
                        ConfigurationEditorComponent.this.editableConfig.setString(st.nextToken(), null, st.nextToken(), dlg.getValue());
                        ConfigurationEditorComponent.this.markDirty();
                    } else if (st.countTokens() == 3) {
                        ConfigurationEditorComponent.this.editableConfig.setString(st.nextToken(), st.nextToken(), st.nextToken(), dlg.getValue());
                        ConfigurationEditorComponent.this.markDirty();
                    } else {
                        Activator.handleError(UIText.ConfigurationEditorComponent_WrongNumberOfTokensMessage, null, true);
                    }
                }
            }
        });
        this.remove = new Button(buttonPanel, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.remove);
        this.remove.setText(UIText.ConfigurationEditorComponent_RemoveAllButton);
        this.remove.setToolTipText(UIText.ConfigurationEditorComponent_RemoveAllTooltip);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Section) {
                    Section section = (Section)first;
                    if (MessageDialog.openConfirm((Shell)ConfigurationEditorComponent.this.getShell(), (String)UIText.ConfigurationEditorComponent_RemoveSectionTitle, (String)NLS.bind((String)UIText.ConfigurationEditorComponent_RemoveSectionMessage, (Object)section.name))) {
                        ConfigurationEditorComponent.this.editableConfig.unsetSection(section.name, null);
                        ConfigurationEditorComponent.this.markDirty();
                    }
                } else if (first instanceof SubSection) {
                    SubSection section = (SubSection)first;
                    if (MessageDialog.openConfirm((Shell)ConfigurationEditorComponent.this.getShell(), (String)UIText.ConfigurationEditorComponent_RemoveSubsectionTitle, (String)NLS.bind((String)UIText.ConfigurationEditorComponent_RemoveSubsectionMessage, (Object)(String.valueOf(section.parent.name) + ConfigurationEditorComponent.DOT + section.name)))) {
                        ConfigurationEditorComponent.this.editableConfig.unsetSection(section.parent.name, section.name);
                        ConfigurationEditorComponent.this.markDirty();
                    }
                } else {
                    Activator.handleError(UIText.ConfigurationEditorComponent_NoSectionSubsectionMessage, null, true);
                }
                super.widgetSelected(e);
            }
        });
        Composite valuePanel = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)valuePanel);
        valuePanel.setLayout((Layout)new GridLayout(3, false));
        new Label(valuePanel, 0).setText(UIText.ConfigurationEditorComponent_ValueLabel);
        this.valueText = new Text(valuePanel, 2048);
        this.valueText.setText(UIText.ConfigurationEditorComponent_NoEntrySelectedMessage);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.valueText);
        Composite buttonContainer = new Composite(valuePanel, 0);
        buttonContainer.setLayout((Layout)new GridLayout(3, true));
        this.changeValue = new Button(buttonContainer, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.changeValue);
        this.changeValue.setText(UIText.ConfigurationEditorComponent_ChangeButton);
        this.changeValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Entry) {
                    Entry entry = (Entry)first;
                    entry.changeValue(ConfigurationEditorComponent.this.valueText.getText());
                    ConfigurationEditorComponent.this.markDirty();
                }
            }
        });
        this.deleteValue = new Button(buttonContainer, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteValue);
        this.deleteValue.setText(UIText.ConfigurationEditorComponent_DeleteButton);
        this.deleteValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Entry) {
                    Entry entry = (Entry)first;
                    entry.removeValue();
                    ConfigurationEditorComponent.this.markDirty();
                }
            }
        });
        this.addValue = new Button(buttonContainer, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.addValue);
        this.addValue.setText(UIText.ConfigurationEditorComponent_AddButton);
        this.addValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ConfigurationEditorComponent.this.tv.getSelection();
                Object first = sel.getFirstElement();
                if (first instanceof Entry) {
                    Entry entry = (Entry)first;
                    entry.addValue(ConfigurationEditorComponent.this.valueText.getText());
                    ConfigurationEditorComponent.this.markDirty();
                }
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationEditorComponent.this.updateEnablement();
            }
        });
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConfigurationEditorComponent.this.valueText.getText().length() == 0) {
                    ConfigurationEditorComponent.this.setErrorMessage(UIText.ConfigurationEditorComponent_EmptyStringNotAllowed);
                    ConfigurationEditorComponent.this.changeValue.setEnabled(false);
                } else {
                    ConfigurationEditorComponent.this.setErrorMessage(null);
                    ConfigurationEditorComponent.this.changeValue.setEnabled(true);
                }
            }
        });
        this.initControlsFromConfig();
        return main;
    }

    private boolean isWriteable(File f) {
        if (f.exists()) {
            if (f.isFile()) {
                return f.canWrite();
            }
            return false;
        }
        File d = f.getParentFile();
        while (d != null) {
            if (d.isDirectory()) {
                return d.canWrite();
            }
            if (d.exists()) {
                return false;
            }
            d = d.getParentFile();
        }
        return false;
    }

    private void initControlsFromConfig() {
        try {
            this.editableConfig.load();
            this.tv.setInput((Object)this.editableConfig);
            if (this.editableConfig instanceof FileBasedConfig) {
                FileBasedConfig fileConfig = (FileBasedConfig)this.editableConfig;
                File configFile = fileConfig.getFile();
                if (configFile != null) {
                    if (this.isWriteable(configFile)) {
                        this.location.setText(configFile.getPath());
                    } else {
                        this.location.setText(NLS.bind((String)UIText.ConfigurationEditorComponent_ReadOnlyLocationFormat, (Object)configFile.getPath()));
                    }
                } else {
                    this.location.setText(UIText.ConfigurationEditorComponent_NoConfigLocationKnown);
                }
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (ConfigInvalidException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        this.tv.expandAll();
        this.updateEnablement();
    }

    protected void setErrorMessage(String message) {
    }

    protected void setDirty(boolean dirty) {
    }

    private void updateEnablement() {
        boolean sectionOrSubSectionSelected;
        Object selected = ((IStructuredSelection)this.tv.getSelection()).getFirstElement();
        boolean entrySelected = selected instanceof Entry;
        boolean bl = sectionOrSubSectionSelected = selected instanceof Section || selected instanceof SubSection;
        if (entrySelected) {
            this.valueText.setText(((Entry)selected).value);
        } else {
            this.valueText.setText(UIText.ConfigurationEditorComponent_NoEntrySelectedMessage);
        }
        this.changeValue.setEnabled(false);
        this.valueText.setEnabled(entrySelected);
        this.deleteValue.setEnabled(entrySelected);
        this.addValue.setEnabled(entrySelected);
        this.remove.setEnabled(sectionOrSubSectionSelected);
    }

    private void markDirty() {
        this.setDirty(true);
        this.tv.refresh();
    }

    private Shell getShell() {
        return this.shellProvider.getShell();
    }

    private static final class ConfigEditorContentProvider
    implements ITreeContentProvider {
        Config userConfig;

        private ConfigEditorContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.userConfig == null) {
                return null;
            }
            ArrayList<Section> sections = new ArrayList<Section>();
            Set sectionNames = this.userConfig.getSections();
            for (String sectionName : sectionNames) {
                sections.add(new Section(this.userConfig, sectionName));
            }
            Collections.sort(sections, new Comparator<Section>(){

                @Override
                public int compare(Section o1, Section o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            return sections.toArray();
        }

        public void dispose() {
            this.userConfig = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.userConfig = (Config)newInput;
        }

        public Object[] getChildren(Object parentElement) {
            int n;
            ArrayList<Object> result = new ArrayList<Object>();
            if (parentElement instanceof Section) {
                Section section = (Section)parentElement;
                Set subSectionNames = this.userConfig.getSubsections(((Section)parentElement).name);
                for (String subSectionName : subSectionNames) {
                    result.add(new SubSection(section, subSectionName));
                }
                Set entryNames = this.userConfig.getNames(section.name);
                for (String entryName : entryNames) {
                    String[] values = this.userConfig.getStringList(section.name, null, entryName);
                    if (values.length == 1) {
                        result.add(new Entry(section, entryName, values[0], -1));
                        continue;
                    }
                    int index = 0;
                    String[] stringArray = values;
                    int n2 = values.length;
                    n = 0;
                    while (n < n2) {
                        String value = stringArray[n];
                        result.add(new Entry(section, entryName, value, index++));
                        ++n;
                    }
                }
            }
            if (parentElement instanceof SubSection) {
                SubSection subSection = (SubSection)parentElement;
                Set entryNames = this.userConfig.getNames(subSection.parent.name, subSection.name);
                for (String entryName : entryNames) {
                    String[] values = this.userConfig.getStringList(subSection.parent.name, subSection.name, entryName);
                    if (values.length == 1) {
                        result.add(new Entry(subSection, entryName, values[0], -1));
                        continue;
                    }
                    int index = 0;
                    String[] stringArray = values;
                    n = values.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String value = stringArray[n3];
                        result.add(new Entry(subSection, entryName, value, index++));
                        ++n3;
                    }
                }
            }
            return result.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Section) {
                return null;
            }
            if (element instanceof SubSection) {
                return ((SubSection)element).parent;
            }
            if (element instanceof Entry) {
                Entry entry = (Entry)element;
                if (entry.sectionparent != null) {
                    return entry.sectionparent;
                }
                return entry.subsectionparent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }
    }

    private static final class ConfigEditorLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private Font boldFont = null;
        private final Font defaultFont;

        public ConfigEditorLabelProvider(Font defaultFont) {
            this.defaultFont = defaultFont;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof Section) {
                        return ((Section)element).name;
                    }
                    if (element instanceof SubSection) {
                        return ((SubSection)element).name;
                    }
                    if (element instanceof Entry) {
                        Entry entry = (Entry)element;
                        if (entry.index < 0) {
                            return entry.name;
                        }
                        return String.valueOf(entry.name) + "[" + entry.index + "]";
                    }
                    return null;
                }
                case 1: {
                    if (element instanceof Entry) {
                        return ((Entry)element).value;
                    }
                    return null;
                }
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof Section || element instanceof SubSection) {
                return this.getBoldFont();
            }
            return null;
        }

        private Font getBoldFont() {
            if (this.boldFont != null) {
                return this.boldFont;
            }
            FontData[] data = this.defaultFont.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(data[i].getStyle() | 1);
                ++i;
            }
            this.boldFont = new Font((Device)Display.getDefault(), data);
            return this.boldFont;
        }

        public void dispose() {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            super.dispose();
        }
    }

    private static final class Entry {
        private final Section sectionparent;
        private final SubSection subsectionparent;
        private final String name;
        private final String value;
        private final int index;

        Entry(Section parent, String name, String value, int index) {
            this.sectionparent = parent;
            this.subsectionparent = null;
            this.name = name;
            this.value = value;
            this.index = index;
        }

        public void addValue(String newValue) {
            if (newValue.length() == 0) {
                throw new IllegalArgumentException(UIText.ConfigurationEditorComponent_EmptyStringNotAllowed);
            }
            Config config = this.getConfig();
            if (this.sectionparent != null) {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.sectionparent.name, null, this.name)));
                entries.add(Math.max(this.index, 0), newValue);
                config.setStringList(this.sectionparent.name, null, this.name, entries);
            } else {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name)));
                entries.add(Math.max(this.index, 0), newValue);
                config.setStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, entries);
            }
        }

        Entry(SubSection parent, String name, String value, int index) {
            this.sectionparent = null;
            this.subsectionparent = parent;
            this.name = name;
            this.value = value;
            this.index = index;
        }

        public void changeValue(String newValue) throws IllegalArgumentException {
            if (newValue.length() == 0) {
                throw new IllegalArgumentException(UIText.ConfigurationEditorComponent_EmptyStringNotAllowed);
            }
            Config config = this.getConfig();
            if (this.index < 0) {
                if (this.sectionparent != null) {
                    config.setString(this.sectionparent.name, null, this.name, newValue);
                } else {
                    config.setString(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, newValue);
                }
            } else if (this.sectionparent != null) {
                String[] entries = config.getStringList(this.sectionparent.name, null, this.name);
                entries[this.index] = newValue;
                config.setStringList(this.sectionparent.name, null, this.name, Arrays.asList(entries));
            } else {
                String[] entries = config.getStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name);
                entries[this.index] = newValue;
                config.setStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, Arrays.asList(entries));
            }
        }

        private Config getConfig() {
            Config config = this.sectionparent != null ? this.sectionparent.config : this.subsectionparent.parent.config;
            return config;
        }

        public void removeValue() {
            Config config = this.getConfig();
            if (this.index < 0) {
                if (this.sectionparent != null) {
                    config.unset(this.sectionparent.name, null, this.name);
                } else {
                    config.unset(this.subsectionparent.parent.name, this.subsectionparent.name, this.name);
                }
            } else if (this.sectionparent != null) {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.sectionparent.name, null, this.name)));
                entries.remove(this.index);
                config.setStringList(this.sectionparent.name, null, this.name, entries);
            } else {
                ArrayList<String> entries = new ArrayList<String>(Arrays.asList(config.getStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name)));
                entries.remove(this.index);
                config.setStringList(this.subsectionparent.parent.name, this.subsectionparent.name, this.name, entries);
            }
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.sectionparent == null ? 0 : this.sectionparent.hashCode());
            result = 31 * result + (this.subsectionparent == null ? 0 : this.subsectionparent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.index != other.index && (this.index > 0 || other.index > 0)) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.sectionparent == null ? other.sectionparent != null : !this.sectionparent.equals(other.sectionparent)) {
                return false;
            }
            return !(this.subsectionparent == null ? other.subsectionparent != null : !this.subsectionparent.equals(other.subsectionparent));
        }
    }

    private static final class Section {
        private final String name;
        private final Config config;

        Section(Config config, String name) {
            this.config = config;
            this.name = name;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Section other = (Section)obj;
            return this.name.equals(other.name);
        }
    }

    private static final class SubSection {
        private final Section parent;
        private final String name;

        SubSection(Section parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.parent.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubSection other = (SubSection)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.parent.equals(other.parent);
        }
    }
}

