/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class GitDecoratorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private GeneralTab generalTab;
    private TextDecorationTab textDecorationTab;
    private IconDecorationTab iconDecorationTab;
    private Preview preview;
    private static final Collection PREVIEW_FILESYSTEM_ROOT;
    private static final Map<String, String> FILE_AND_FOLDER_BINDINGS;
    private static final Map<String, String> PROJECT_BINDINGS;
    private static IPropertyChangeListener themeListener;

    static {
        PreviewResource project = new PreviewResource("Project", 4, "repository|" + RepositoryState.MERGING.getDescription(), "master", true, false, true, IDecoratableResource.Staged.NOT_STAGED, false, false);
        ArrayList<PreviewResource> children = new ArrayList<PreviewResource>();
        children.add(new PreviewResource("folder", 2, "repository", null, true, false, true, IDecoratableResource.Staged.NOT_STAGED, false, false));
        children.add(new PreviewResource("tracked.txt", 1, "repository", null, true, false, false, IDecoratableResource.Staged.NOT_STAGED, false, false));
        children.add(new PreviewResource("untracked.txt", 1, "repository", null, false, false, false, IDecoratableResource.Staged.NOT_STAGED, false, false));
        children.add(new PreviewResource("ignored.txt", 1, "repository", null, false, true, false, IDecoratableResource.Staged.NOT_STAGED, false, false));
        children.add(new PreviewResource("dirty.txt", 1, "repository", null, true, false, true, IDecoratableResource.Staged.NOT_STAGED, false, false));
        children.add(new PreviewResource("staged.txt", 1, "repository", null, true, false, false, IDecoratableResource.Staged.MODIFIED, false, false));
        children.add(new PreviewResource("partially-staged.txt", 1, "repository", null, true, false, true, IDecoratableResource.Staged.MODIFIED, false, false));
        children.add(new PreviewResource("added.txt", 1, "repository", null, true, false, false, IDecoratableResource.Staged.ADDED, false, false));
        children.add(new PreviewResource("removed.txt", 1, "repository", null, true, false, false, IDecoratableResource.Staged.REMOVED, false, false));
        children.add(new PreviewResource("conflict.txt", 1, "repository", null, true, false, true, IDecoratableResource.Staged.NOT_STAGED, true, false));
        children.add(new PreviewResource("assume-valid.txt", 1, "repository", null, true, false, false, IDecoratableResource.Staged.NOT_STAGED, false, true));
        project.children = children;
        PREVIEW_FILESYSTEM_ROOT = Collections.singleton(project);
        FILE_AND_FOLDER_BINDINGS = new HashMap<String, String>();
        FILE_AND_FOLDER_BINDINGS.put("name", UIText.DecoratorPreferencesPage_bindingResourceName);
        FILE_AND_FOLDER_BINDINGS.put("dirty", UIText.DecoratorPreferencesPage_bindingDirtyFlag);
        FILE_AND_FOLDER_BINDINGS.put("staged", UIText.DecoratorPreferencesPage_bindingStagedFlag);
        PROJECT_BINDINGS = new HashMap<String, String>();
        PROJECT_BINDINGS.put("name", UIText.DecoratorPreferencesPage_bindingResourceName);
        PROJECT_BINDINGS.put("dirty", UIText.DecoratorPreferencesPage_bindingDirtyFlag);
        PROJECT_BINDINGS.put("staged", UIText.DecoratorPreferencesPage_bindingStagedFlag);
        PROJECT_BINDINGS.put("repository", UIText.GitDecoratorPreferencePage_bindingRepositoryNameFlag);
        PROJECT_BINDINGS.put("branch", UIText.DecoratorPreferencesPage_bindingBranchName);
    }

    public GitDecoratorPreferencePage() {
        this.setDescription(UIText.DecoratorPreferencesPage_description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite(parent, 0);
        SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)this.getContainer(), composite, "org.eclipse.ui.preferencePages.Decorators", UIText.DecoratorPreferencesPage_labelDecorationsLink);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.generalTab = new GeneralTab(tabFolder);
        this.textDecorationTab = new TextDecorationTab(tabFolder);
        this.iconDecorationTab = new IconDecorationTab(tabFolder);
        this.initializeValues();
        this.preview = new Preview(composite);
        this.preview.refresh();
        this.generalTab.addObserver(this.preview);
        this.textDecorationTab.addObserver(this.preview);
        this.iconDecorationTab.addObserver(this.preview);
        themeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GitDecoratorPreferencePage.this.preview.refresh();
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(themeListener);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.generalTab.initializeValues(store);
        this.textDecorationTab.initializeValues(store);
        this.iconDecorationTab.initializeValues(store);
        this.setValid(true);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean okToClose = this.performOk(store);
        if (store.needsSaving()) {
            try {
                ((IPersistentPreferenceStore)store).save();
                Activator.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.egit.ui.DECORATORS_CHANGED", null, null));
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return okToClose;
    }

    private boolean performOk(IPreferenceStore store) {
        this.generalTab.performOk(store);
        this.textDecorationTab.performOk(store);
        this.iconDecorationTab.performOk(store);
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.generalTab.performDefaults(store);
        this.textDecorationTab.performDefaults(store);
        this.iconDecorationTab.performDefaults(store);
        super.performDefaults();
        this.preview.refresh();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(themeListener);
        super.dispose();
    }

    private class GeneralTab
    extends Tab
    implements SelectionListener {
        private Button recomputeAncestorDecorations;
        private Scale containerRecurseLimit;

        public GeneralTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 1);
            this.recomputeAncestorDecorations = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_recomputeAncestorDecorations);
            this.recomputeAncestorDecorations.setToolTipText(UIText.DecoratorPreferencesPage_recomputeAncestorDecorationsTooltip);
            SWTUtils.createLabel(composite, UIText.DecoratorPreferencesPage_computeRecursiveLimit);
            this.containerRecurseLimit = this.createLabeledScaleControl(composite);
            this.containerRecurseLimit.setToolTipText(UIText.DecoratorPreferencesPage_computeRecursiveLimitTooltip);
            this.recomputeAncestorDecorations.addSelectionListener((SelectionListener)this);
            this.containerRecurseLimit.addSelectionListener((SelectionListener)this);
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_generalTabFolder);
            tabItem.setControl((Control)composite);
        }

        public void initializeValues(IPreferenceStore store) {
            this.recomputeAncestorDecorations.setSelection(store.getBoolean("decorator_recompute_ancestors"));
            this.containerRecurseLimit.setSelection(store.getInt("decorator_recursive_limit"));
        }

        public void performDefaults(IPreferenceStore store) {
            this.recomputeAncestorDecorations.setSelection(store.getDefaultBoolean("decorator_recompute_ancestors"));
            this.containerRecurseLimit.setSelection(store.getDefaultInt("decorator_recursive_limit"));
        }

        public void performOk(IPreferenceStore store) {
            store.setValue("decorator_recompute_ancestors", this.recomputeAncestorDecorations.getSelection());
            store.setValue("decorator_recursive_limit", this.containerRecurseLimit.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private Scale createLabeledScaleControl(Composite parent) {
            int[] nArray = new int[11];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 5;
            nArray[5] = 10;
            nArray[6] = 15;
            nArray[7] = 20;
            nArray[8] = 50;
            nArray[9] = 100;
            nArray[10] = Integer.MAX_VALUE;
            int[] values = nArray;
            Composite composite = SWTUtils.createHVFillComposite(parent, -1);
            Composite labels = SWTUtils.createHVFillComposite(composite, 0, values.length);
            GridLayout labelsLayout = (GridLayout)labels.getLayout();
            labelsLayout.makeColumnsEqualWidth = true;
            labelsLayout.horizontalSpacing = 0;
            labels.setLayoutData((Object)SWTUtils.createGridData(-1, -1, 4, 4, false, false));
            int i = 0;
            while (i < values.length) {
                Label label = SWTUtils.createLabel(labels, "" + values[i]);
                if (i == 0) {
                    label.setAlignment(16384);
                    label.setText("Off");
                } else if (i == values.length - 1) {
                    label.setAlignment(131072);
                    label.setText("Inf.");
                } else {
                    label.setAlignment(0x1000000);
                }
                ++i;
            }
            final Scale scale = new Scale(composite, 256);
            scale.setLayoutData((Object)SWTUtils.createHVFillGridData());
            scale.setMaximum(values.length - 1);
            scale.setMinimum(0);
            scale.setIncrement(1);
            scale.setPageIncrement(1);
            scale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    scale.setSelection(scale.getSelection());
                }
            });
            return scale;
        }
    }

    private class IconDecorationTab
    extends Tab
    implements SelectionListener {
        private Button showTracked;
        private Button showUntracked;
        private Button showStaged;
        private Button showConflicts;
        private Button showAssumeValid;
        private Button showDirty;

        public IconDecorationTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 2);
            this.showTracked = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowTracked);
            this.showUntracked = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowUntracked);
            this.showStaged = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowStaged);
            this.showConflicts = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowConflicts);
            this.showAssumeValid = SWTUtils.createCheckBox(composite, UIText.DecoratorPreferencesPage_iconsShowAssumeValid);
            this.showDirty = SWTUtils.createCheckBox(composite, UIText.GitDecoratorPreferencePage_iconsShowDirty);
            this.showTracked.addSelectionListener((SelectionListener)this);
            this.showUntracked.addSelectionListener((SelectionListener)this);
            this.showStaged.addSelectionListener((SelectionListener)this);
            this.showConflicts.addSelectionListener((SelectionListener)this);
            this.showAssumeValid.addSelectionListener((SelectionListener)this);
            this.showDirty.addSelectionListener((SelectionListener)this);
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_iconLabel);
            tabItem.setControl((Control)composite);
        }

        public void initializeValues(IPreferenceStore store) {
            this.showTracked.setSelection(store.getBoolean("decorator_show_tracked_icon"));
            this.showUntracked.setSelection(store.getBoolean("decorator_show_untracked_icon"));
            this.showStaged.setSelection(store.getBoolean("decorator_show_staged_icon"));
            this.showConflicts.setSelection(store.getBoolean("decorator_show_conflicts_icon"));
            this.showAssumeValid.setSelection(store.getBoolean("decorator_show_assume_valid_icon"));
            this.showDirty.setSelection(store.getBoolean("decorator_show_dirty_icon"));
        }

        public void performDefaults(IPreferenceStore store) {
            this.showTracked.setSelection(store.getDefaultBoolean("decorator_show_tracked_icon"));
            this.showUntracked.setSelection(store.getDefaultBoolean("decorator_show_untracked_icon"));
            this.showStaged.setSelection(store.getDefaultBoolean("decorator_show_staged_icon"));
            this.showConflicts.setSelection(store.getDefaultBoolean("decorator_show_conflicts_icon"));
            this.showAssumeValid.setSelection(store.getDefaultBoolean("decorator_show_assume_valid_icon"));
            this.showDirty.setSelection(store.getDefaultBoolean("decorator_show_dirty_icon"));
        }

        public void performOk(IPreferenceStore store) {
            store.setValue("decorator_show_tracked_icon", this.showTracked.getSelection());
            store.setValue("decorator_show_untracked_icon", this.showUntracked.getSelection());
            store.setValue("decorator_show_staged_icon", this.showStaged.getSelection());
            store.setValue("decorator_show_conflicts_icon", this.showConflicts.getSelection());
            store.setValue("decorator_show_assume_valid_icon", this.showAssumeValid.getSelection());
            store.setValue("decorator_show_dirty_icon", this.showDirty.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class Preview
    extends LabelProvider
    implements Observer,
    ITreeContentProvider {
        private final ResourceManager fImageCache;
        private final TreeViewer fViewer;
        private GitLightweightDecorator.DecorationHelper fHelper;

        public Preview(Composite composite) {
            this.reloadDecorationHelper();
            SWTUtils.createLabel(composite, UIText.DecoratorPreferencesPage_preview);
            this.fImageCache = new LocalResourceManager(JFaceResources.getResources());
            this.fViewer = new TreeViewer(composite);
            this.fViewer.getControl().setLayoutData((Object)SWTUtils.createHVFillGridData());
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setLabelProvider((IBaseLabelProvider)this);
            this.fViewer.setInput((Object)PREVIEW_FILESYSTEM_ROOT);
            this.fViewer.expandAll();
            this.fHelper = new GitLightweightDecorator.DecorationHelper((IPreferenceStore)new PreferenceStore());
        }

        private void reloadDecorationHelper() {
            PreferenceStore store = new PreferenceStore();
            GitDecoratorPreferencePage.this.performOk((IPreferenceStore)store);
            this.fHelper = new GitLightweightDecorator.DecorationHelper((IPreferenceStore)store);
        }

        public void refresh() {
            this.reloadDecorationHelper();
            this.fViewer.refresh(true);
            this.setColorsAndFonts(this.fViewer.getTree().getItems());
        }

        private void setColorsAndFonts(TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                PreviewDecoration decoration = this.getDecoration(items[i].getData());
                items[i].setBackground(decoration.getBackgroundColor());
                items[i].setForeground(decoration.getForegroundColor());
                items[i].setFont(decoration.getFont());
                this.setColorsAndFonts(items[i].getItems());
                ++i;
            }
        }

        public void update(Observable o, Object arg) {
            this.refresh();
        }

        public Object[] getChildren(Object parentElement) {
            return ((PreviewResource)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((PreviewResource)element).children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void dispose() {
            this.fImageCache.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            PreviewDecoration decoration = this.getDecoration(element);
            StringBuilder buffer = new StringBuilder();
            String prefix = decoration.getPrefix();
            if (prefix != null) {
                buffer.append(prefix);
            }
            buffer.append(((PreviewResource)element).getName());
            String suffix = decoration.getSuffix();
            if (suffix != null) {
                buffer.append(suffix);
            }
            return buffer.toString();
        }

        public Image getImage(Object element) {
            String s;
            switch (((PreviewResource)element).type) {
                case 4: {
                    s = "IMG_OBJ_PROJECT";
                    break;
                }
                case 2: {
                    s = "IMG_OBJ_FOLDER";
                    break;
                }
                default: {
                    s = "IMG_OBJ_FILE";
                }
            }
            Image baseImage = PlatformUI.getWorkbench().getSharedImages().getImage(s);
            ImageDescriptor overlay = this.getDecoration(element).getOverlay();
            if (overlay == null) {
                return baseImage;
            }
            try {
                return this.fImageCache.createImage((ImageDescriptor)new DecorationOverlayIcon(baseImage, overlay, 3));
            }
            catch (Exception e) {
                Activator.logError(e.getMessage(), e);
                return null;
            }
        }

        private PreviewDecoration getDecoration(Object element) {
            PreviewDecoration decoration = new PreviewDecoration();
            this.fHelper.decorate(decoration, (PreviewResource)element);
            return decoration;
        }
    }

    private static class PreviewDecoration
    implements IDecoration {
        private List<String> prefixes = new ArrayList<String>();
        private List<String> suffixes = new ArrayList<String>();
        private ImageDescriptor overlay = null;
        private Color backgroundColor = null;
        private Font font = null;
        private Color foregroundColor = null;

        private PreviewDecoration() {
        }

        public void addOverlay(ImageDescriptor overlayImage) {
            if (this.overlay == null) {
                this.overlay = overlayImage;
            }
        }

        public void addOverlay(ImageDescriptor overlayImage, int quadrant) {
            this.addOverlay(overlayImage);
        }

        public void addPrefix(String prefix) {
            this.prefixes.add(prefix);
        }

        public void addSuffix(String suffix) {
            this.suffixes.add(suffix);
        }

        public IDecorationContext getDecorationContext() {
            return new DecorationContext();
        }

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
        }

        public void setForegroundColor(Color color) {
            this.foregroundColor = color;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public ImageDescriptor getOverlay() {
            return this.overlay;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public Color getForegroundColor() {
            return this.foregroundColor;
        }

        public Font getFont() {
            return this.font;
        }

        public String getPrefix() {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iter = this.prefixes.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
            }
            return sb.toString();
        }

        public String getSuffix() {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iter = this.suffixes.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
            }
            return sb.toString();
        }
    }

    private static class PreviewResource
    implements IDecoratableResource {
        private final String name;
        private final String repositoryName;
        private final String branch;
        private final int type;
        private Collection children;
        private boolean tracked;
        private boolean ignored;
        private boolean dirty;
        private boolean conflicts;
        private IDecoratableResource.Staged staged;
        private boolean assumeValid;

        public PreviewResource(String name, int type, String repositoryName, String branch, boolean tracked, boolean ignored, boolean dirty, IDecoratableResource.Staged staged, boolean conflicts, boolean assumeValid) {
            this.name = name;
            this.repositoryName = repositoryName;
            this.branch = branch;
            this.type = type;
            this.children = Collections.EMPTY_LIST;
            this.tracked = tracked;
            this.ignored = ignored;
            this.dirty = dirty;
            this.staged = staged;
            this.conflicts = conflicts;
            this.assumeValid = assumeValid;
        }

        public String getName() {
            return this.name;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public int getType() {
            return this.type;
        }

        public String getBranch() {
            return this.branch;
        }

        public boolean isTracked() {
            return this.tracked;
        }

        public boolean isIgnored() {
            return this.ignored;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public IDecoratableResource.Staged staged() {
            return this.staged;
        }

        public boolean hasConflicts() {
            return this.conflicts;
        }

        public boolean isAssumeValid() {
            return this.assumeValid;
        }
    }

    private abstract class Tab
    extends Observable {
        private Tab() {
        }

        public abstract void initializeValues(IPreferenceStore var1);

        public abstract void performDefaults(IPreferenceStore var1);

        public abstract void performOk(IPreferenceStore var1);
    }

    private class TextDecorationTab
    extends Tab
    implements ModifyListener {
        private final FormatEditor fileTextFormat;
        private final FormatEditor folderTextFormat;
        private final FormatEditor projectTextFormat;

        public TextDecorationTab(TabFolder parent) {
            Composite composite = SWTUtils.createHVFillComposite((Composite)parent, -1, 3);
            this.fileTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_fileFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction, FILE_AND_FOLDER_BINDINGS, "decorator_filetext_decoration");
            this.folderTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_folderFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction2, FILE_AND_FOLDER_BINDINGS, "decorator_foldertext_decoration");
            this.projectTextFormat = new FormatEditor(composite, UIText.DecoratorPreferencesPage_projectFormatLabel, UIText.DecoratorPreferencesPage_addVariablesAction3, PROJECT_BINDINGS, "decorator_projecttext_decoration");
            this.fileTextFormat.addModifyListener(this);
            this.folderTextFormat.addModifyListener(this);
            this.projectTextFormat.addModifyListener(this);
            TabItem tabItem = new TabItem(parent, 0);
            tabItem.setText(UIText.DecoratorPreferencesPage_textLabel);
            tabItem.setControl((Control)composite);
        }

        public void initializeValues(IPreferenceStore store) {
            this.fileTextFormat.initializeValue(store);
            this.folderTextFormat.initializeValue(store);
            this.projectTextFormat.initializeValue(store);
        }

        public void performDefaults(IPreferenceStore store) {
            this.fileTextFormat.performDefaults(store);
            this.folderTextFormat.performDefaults(store);
            this.projectTextFormat.performDefaults(store);
        }

        public void performOk(IPreferenceStore store) {
            this.fileTextFormat.performOk(store);
            this.folderTextFormat.performOk(store);
            this.projectTextFormat.performOk(store);
        }

        public void modifyText(ModifyEvent e) {
            this.setChanged();
            this.notifyObservers();
        }

        private class FormatEditor
        extends SelectionAdapter {
            private final Text text;
            private final Map bindings;
            private final String key;

            public FormatEditor(Composite composite, String title, String buttonText, Map bindings, String key) {
                this.key = key;
                this.bindings = bindings;
                Label label = SWTUtils.createLabel(composite, title);
                label.setLayoutData((Object)SWTUtils.createGridData(-1, -1, false, false));
                this.text = SWTUtils.createText(composite);
                Button button = new Button(composite, 0);
                button.setText(buttonText);
                button.setLayoutData((Object)new GridData());
                button.addSelectionListener((SelectionListener)this);
            }

            public void addModifyListener(ModifyListener listener) {
                this.text.addModifyListener(listener);
            }

            public void widgetSelected(SelectionEvent e) {
                LabelProvider labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        return ((Map.Entry)element).getKey() + " - " + ((Map.Entry)element).getValue();
                    }
                };
                ArrayContentProvider contentsProvider = ArrayContentProvider.getInstance();
                ListSelectionDialog dialog = new ListSelectionDialog(this.text.getShell(), this.bindings.entrySet(), (IStructuredContentProvider)contentsProvider, (ILabelProvider)labelProvider, UIText.DecoratorPreferencesPage_selectVariablesToAdd);
                dialog.setHelpAvailable(false);
                dialog.setTitle(UIText.DecoratorPreferencesPage_addVariablesTitle);
                if (dialog.open() != 0) {
                    return;
                }
                Object[] result = dialog.getResult();
                int i = 0;
                while (i < result.length) {
                    this.text.insert("{" + ((Map.Entry)result[i]).getKey() + "}");
                    ++i;
                }
            }

            public void performOk(IPreferenceStore store) {
                store.setValue(this.key, this.text.getText());
            }

            public void performDefaults(IPreferenceStore store) {
                store.setToDefault(this.key);
                this.text.setText(store.getDefaultString(this.key));
            }

            public void initializeValue(IPreferenceStore store) {
                this.text.setText(store.getString(this.key));
            }
        }
    }
}

