/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class GitProjectPropertyPage
extends PropertyPage {
    private Text gitDir;
    private Text branch;
    private Text id;
    private Text state;
    private Text workDir;

    protected Control createContents(Composite parent) {
        Composite composite;
        block6: {
            this.noDefaultAndApplyButton();
            composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            this.gitDir = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelGitDir);
            this.workDir = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelWorkdir);
            this.branch = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelBranch);
            this.id = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelId);
            this.state = this.createLabeledReadOnlyText(composite, UIText.GitProjectPropertyPage_LabelState);
            IProject project = null;
            IAdaptable element = this.getElement();
            if (element instanceof IProject) {
                project = (IProject)element;
            } else {
                Object adapter = element.getAdapter(IProject.class);
                if (adapter instanceof IProject) {
                    project = (IProject)adapter;
                }
            }
            Repository repository = RepositoryMapping.getMapping((IResource)project).getRepository();
            if (repository != null) {
                try {
                    this.fillValues(repository);
                }
                catch (IOException e) {
                    if (!GitTraceLocation.UI.isActive()) break block6;
                    GitTraceLocation.getTrace().trace(GitTraceLocation.UI.getLocation(), e.getMessage(), (Throwable)e);
                }
            }
        }
        return composite;
    }

    private void fillValues(Repository repository) throws IOException {
        this.gitDir.setText(repository.getDirectory().getAbsolutePath());
        this.branch.setText(repository.getBranch());
        this.workDir.setText(repository.getWorkTree().getAbsolutePath());
        this.state.setText(repository.getRepositoryState().getDescription());
        ObjectId objectId = repository.resolve(repository.getFullBranch());
        if (objectId == null) {
            if (repository.getAllRefs().size() == 0) {
                this.id.setText(UIText.GitProjectPropertyPage_ValueEmptyRepository);
            } else {
                this.id.setText(UIText.GitProjectPropertyPage_ValueUnbornBranch);
            }
        } else {
            this.id.setText(objectId.name());
        }
    }

    protected Text createLabeledReadOnlyText(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        Text text = new Text(parent, 16392);
        text.setBackground(Display.getDefault().getSystemColor(22));
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        text.setLayoutData((Object)data);
        return text;
    }
}

