/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.preferences.ConfigurationEditorComponent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GlobalConfigurationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.egit.ui.internal.preferences.GlobalConfigurationPreferencePage";
    private FileBasedConfig userConfig;
    private FileBasedConfig sysConfig;
    private boolean userIsDirty;
    private boolean sysIsDirty;
    private ConfigurationEditorComponent userConfigEditor;
    private ConfigurationEditorComponent sysConfigEditor;

    protected Control createContents(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite(parent, 0);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.userConfigEditor = new ConfigurationEditorComponent((Composite)tabFolder, (StoredConfig)this.userConfig, true){

            protected void setErrorMessage(String message) {
                GlobalConfigurationPreferencePage.this.setErrorMessage(message);
            }

            protected void setDirty(boolean dirty) {
                GlobalConfigurationPreferencePage.this.userIsDirty = dirty;
                GlobalConfigurationPreferencePage.this.updateApplyButton();
            }
        };
        this.sysConfigEditor = new ConfigurationEditorComponent((Composite)tabFolder, (StoredConfig)this.sysConfig, true){

            protected void setErrorMessage(String message) {
                GlobalConfigurationPreferencePage.this.setErrorMessage(message);
            }

            protected void setDirty(boolean dirty) {
                GlobalConfigurationPreferencePage.this.sysIsDirty = dirty;
                GlobalConfigurationPreferencePage.this.updateApplyButton();
            }
        };
        Control result = this.userConfigEditor.createContents();
        Dialog.applyDialogFont((Control)result);
        TabItem userTabItem = new TabItem(tabFolder, 4);
        userTabItem.setControl(result);
        userTabItem.setText(UIText.GlobalConfigurationPreferencePage_userSettingTabTitle);
        result = this.sysConfigEditor.createContents();
        Dialog.applyDialogFont((Control)result);
        TabItem sysTabItem = new TabItem(tabFolder, 4);
        sysTabItem.setControl(result);
        sysTabItem.setText(UIText.GlobalConfigurationPreferencePage_systemSettingTabTitle);
        return result;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateApplyButton();
        }
        super.setVisible(visible);
    }

    protected void updateApplyButton() {
        if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(this.userIsDirty || this.sysIsDirty);
        }
    }

    public boolean performOk() {
        boolean ok = true;
        if (this.userIsDirty) {
            try {
                this.userConfigEditor.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                ok = false;
            }
        }
        if (this.sysIsDirty) {
            try {
                this.sysConfigEditor.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                ok = false;
            }
        }
        return ok;
    }

    protected void performDefaults() {
        try {
            this.userConfigEditor.restore();
            this.sysConfigEditor.restore();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
        if (this.sysConfig == null) {
            this.sysConfig = SystemReader.getInstance().openSystemConfig(null, FS.DETECTED);
        }
        if (this.userConfig == null) {
            this.userConfig = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
        }
    }
}

