/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PullResultDialog
extends Dialog {
    private final Repository repo;
    private final PullResult result;

    public PullResultDialog(Shell shell, Repository repo, PullResult result) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repo = repo;
        this.result = result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        Group fetchResultGroup = new Group(main, 16);
        fetchResultGroup.setText(UIText.PullResultDialog_FetchResultGroupHeader);
        fetchResultGroup.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fetchResultGroup);
        FetchResult fRes = this.result.getFetchResult();
        if (fRes != null && !fRes.getTrackingRefUpdates().isEmpty()) {
            FetchResultDialog dlg = new FetchResultDialog(this.getParentShell(), this.repo, fRes, this.result.getFetchedFrom());
            Control fresult = dlg.createDialogArea((Composite)fetchResultGroup);
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, 130).applyTo(fresult);
        } else {
            Label noResult = new Label((Composite)fetchResultGroup, 0);
            if (this.result.getFetchedFrom().equals(".")) {
                noResult.setText(UIText.PullResultDialog_NothingToFetchFromLocal);
            } else {
                noResult.setText(NLS.bind((String)UIText.FetchResultDialog_labelEmptyResult, (Object)this.result.getFetchedFrom()));
            }
        }
        Group mergeResultGroup = new Group(main, 16);
        mergeResultGroup.setText(UIText.PullResultDialog_MergeResultGroupHeader);
        mergeResultGroup.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mergeResultGroup);
        MergeResult mRes = this.result.getMergeResult();
        RebaseResult rRes = this.result.getRebaseResult();
        if (mRes != null && mRes.getMergeStatus() != MergeResult.MergeStatus.ALREADY_UP_TO_DATE) {
            MergeResultDialog dlg = new MergeResultDialog(this.getParentShell(), this.repo, mRes);
            dlg.createDialogArea((Composite)mergeResultGroup);
        } else if (rRes != null && rRes.getStatus() != RebaseResult.Status.UP_TO_DATE) {
            switch (rRes.getStatus()) {
                case OK: 
                case ABORTED: 
                case UP_TO_DATE: 
                case FAST_FORWARD: {
                    break;
                }
                case STOPPED: {
                    Label errorLabel = new Label((Composite)mergeResultGroup, 0);
                    errorLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                    Text errorText = new Text((Composite)mergeResultGroup, 8);
                    errorText.setText(UIText.PullResultDialog_RebaseStoppedMessage);
                }
            }
            Label statusLabel = new Label((Composite)mergeResultGroup, 0);
            statusLabel.setText(UIText.PullResultDialog_RebaseStatusLabel);
            Text statusText = new Text((Composite)mergeResultGroup, 8);
            statusText.setText(rRes.getStatus().name());
        } else {
            Label noResult = new Label((Composite)mergeResultGroup, 0);
            noResult.setText(UIText.PullResultDialog_MergeAlreadyUpToDateMessage);
        }
        return main;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.PullResultDialog_DialogTitle);
    }
}

