/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperationUI {
    public static final RefSpec DEFAULT_PUSH_REF_SPEC = new RefSpec("refs/heads/*:refs/heads/*");
    private final Repository repository;
    private final int timeout;
    private final boolean dryRun;
    private final String destinationString;
    private final RemoteConfig config;
    private PushOperationSpecification spec;
    private CredentialsProvider credentialsProvider;
    private PushOperation op;

    public PushOperationUI(Repository repository, RemoteConfig config, int timeout, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = config;
        this.timeout = timeout;
        this.dryRun = dryRun;
        this.destinationString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)config.getName());
    }

    public PushOperationUI(Repository repository, PushOperationSpecification spec, int timeout, boolean dryRun) {
        this.repository = repository;
        this.spec = spec;
        this.config = null;
        this.timeout = timeout;
        this.dryRun = dryRun;
        this.destinationString = spec.getURIsNumber() == 1 ? ((URIish)spec.getURIs().iterator().next()).toPrivateString() : NLS.bind((String)UIText.PushOperationUI_MultiRepositoriesDestinationString, (Object)spec.getURIsNumber());
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public PushOperationResult execute(IProgressMonitor monitor) throws CoreException {
        if (this.spec == null) {
            this.spec = new PushOperationSpecification();
            ArrayList<URIish> urisToPush = new ArrayList<URIish>();
            for (URIish uri : this.config.getPushURIs()) {
                urisToPush.add(uri);
            }
            if (urisToPush.isEmpty() && !this.config.getURIs().isEmpty()) {
                urisToPush.add((URIish)this.config.getURIs().get(0));
            }
            ArrayList<RefSpec> pushRefSpecs = new ArrayList<RefSpec>();
            pushRefSpecs.addAll(this.config.getPushRefSpecs());
            if (pushRefSpecs.isEmpty()) {
                pushRefSpecs.add(DEFAULT_PUSH_REF_SPEC);
            }
            for (URIish uri : urisToPush) {
                try {
                    this.spec.addURIRefUpdates(uri, Transport.open((Repository)this.repository, (URIish)uri).findRemoteRefUpdatesFor(pushRefSpecs));
                }
                catch (NotSupportedException e) {
                    throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
                }
                catch (IOException e) {
                    throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
                }
            }
        }
        this.op = new PushOperation(this.repository, this.spec, this.dryRun, this.timeout);
        if (this.credentialsProvider != null) {
            this.op.setCredentialsProvider(this.credentialsProvider);
        }
        try {
            this.op.run(monitor);
            return this.op.getOperationResult();
        }
        catch (InvocationTargetException e) {
            throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
        }
    }

    public void start() {
        Job job = new Job(NLS.bind((String)UIText.PushOperationUI_PushJobName, (Object)this.destinationString)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PushOperationUI.this.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.PUSH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    PushResultDialog.show(PushOperationUI.this.repository, PushOperationUI.this.op.getOperationResult(), PushOperationUI.this.destinationString);
                } else {
                    Activator.handleError(event.getResult().getMessage(), event.getResult().getException(), true);
                }
            }
        });
    }

    public String getDestinationString() {
        return this.destinationString;
    }
}

