/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.CenteredImageLabelProvider;
import org.eclipse.egit.ui.internal.push.RefUpdateContentProvider;
import org.eclipse.egit.ui.internal.push.RefUpdateElement;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class PushResultTable {
    private static final int TABLE_PREFERRED_WIDTH = 650;
    private static final int TABLE_PREFERRED_HEIGHT = 300;
    private static final int TEXT_PREFERRED_HEIGHT = 100;
    private static final int COLUMN_STATUS_WEIGHT = 40;
    private static final int COLUMN_DST_WEIGHT = 40;
    private static final int COLUMN_SRC_WEIGHT = 40;
    private static final int COLUMN_MODE_WEIGHT = 15;
    private static final String IMAGE_DELETE = "MODE_DELETE";
    private static final String IMAGE_ADD = "MODE_ADD";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private final TableViewer tableViewer;
    private final Composite tablePanel;
    private final ImageRegistry imageRegistry;
    private ObjectReader reader;
    private Map<ObjectId, String> abbrevations;

    PushResultTable(Composite parent) {
        this.tablePanel = new Composite(parent, 0);
        this.tablePanel.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 300;
        layoutData.widthHint = 650;
        this.tableViewer = new TableViewer(this.tablePanel);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.imageRegistry = new ImageRegistry(table.getDisplay());
        this.imageRegistry.put(IMAGE_ADD, UIIcons.ELCL16_ADD);
        this.imageRegistry.put(IMAGE_DELETE, UIIcons.ELCL16_DELETE);
        this.tablePanel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PushResultTable.this.reader != null) {
                    PushResultTable.this.reader.release();
                }
                PushResultTable.this.imageRegistry.dispose();
            }
        });
        this.tableViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new RefUpdateContentProvider());
        this.tableViewer.setInput(null);
        final Text text = new Text(parent, 2058);
        GridData textLayoutData = new GridData(4, 4, true, true);
        textLayoutData.heightHint = 100;
        text.setLayoutData((Object)textLayoutData);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    text.setText(PushResultTable.EMPTY_STRING);
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    text.setText(PushResultTable.EMPTY_STRING);
                    return;
                }
                RefUpdateElement element = (RefUpdateElement)structuredSelection.getFirstElement();
                text.setText(PushResultTable.this.getResult(element));
            }
        });
    }

    private String getResult(RefUpdateElement element) {
        StringBuilder result = new StringBuilder(EMPTY_STRING);
        PushOperationResult pushOperationResult = element.getPushOperationResult();
        Set urIs = pushOperationResult.getURIs();
        Iterator iterator = urIs.iterator();
        while (iterator.hasNext()) {
            boolean lineBreakNeeded = false;
            URIish uri = (URIish)iterator.next();
            result.append(UIText.PushResultTable_repository);
            result.append(SPACE);
            result.append(uri.toString());
            result.append(Text.DELIMITER);
            result.append(Text.DELIMITER);
            String message = element.getRemoteRefUpdate(uri).getMessage();
            if (message != null) {
                result.append(message);
                result.append(Text.DELIMITER);
                lineBreakNeeded = true;
            }
            StringBuilder messagesBuffer = new StringBuilder(pushOperationResult.getPushResult(uri).getMessages());
            PushResultTable.trim(messagesBuffer);
            if (messagesBuffer.length() > 0) {
                result.append((CharSequence)messagesBuffer);
                result.append(Text.DELIMITER);
                lineBreakNeeded = true;
            }
            if (!iterator.hasNext() || !lineBreakNeeded) continue;
            result.append(Text.DELIMITER);
        }
        PushResultTable.trim(result);
        return result.toString();
    }

    private static void trim(StringBuilder s) {
        while (s.length() > 0 && (s.charAt(0) == '\n' || s.charAt(0) == '\r')) {
            s.deleteCharAt(0);
        }
        while (s.length() > 0 && (s.charAt(s.length() - 1) == '\n' || s.charAt(s.length() - 1) == '\r')) {
            s.deleteCharAt(s.length() - 1);
        }
    }

    void setData(Repository localDb, PushOperationResult result) {
        this.reader = localDb.newObjectReader();
        this.abbrevations = new HashMap<ObjectId, String>();
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        this.tableViewer.setInput(null);
        TableColumnLayout layout = new TableColumnLayout();
        this.tablePanel.setLayout((Layout)layout);
        TableViewerColumn modeViewer = this.createColumn(layout, UIText.PushResultTable_columnMode, 15, 0x1000000);
        modeViewer.setLabelProvider((CellLabelProvider)new CenteredImageLabelProvider(){

            public Image getImage(Object element) {
                if (((RefUpdateElement)element).isDelete()) {
                    return PushResultTable.this.imageRegistry.get(PushResultTable.IMAGE_DELETE);
                }
                return PushResultTable.this.imageRegistry.get(PushResultTable.IMAGE_ADD);
            }

            public String getToolTipText(Object element) {
                if (((RefUpdateElement)element).isDelete()) {
                    return UIText.RefSpecPanel_modeDeleteDescription;
                }
                return UIText.RefSpecPanel_modeUpdateDescription;
            }
        });
        TableViewerColumn srcViewer = this.createColumn(layout, UIText.PushResultTable_columnSrc, 40, 16384);
        srcViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RefUpdateElement)element).getSrcRefName();
            }
        });
        TableViewerColumn dstViewer = this.createColumn(layout, UIText.PushResultTable_columnDst, 40, 16384);
        dstViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RefUpdateElement)element).getDstRefName();
            }
        });
        if (result == null) {
            this.tablePanel.layout();
            return;
        }
        int i = 0;
        for (URIish uri : result.getURIs()) {
            TableViewerColumn statusViewer = this.createColumn(layout, NLS.bind((String)UIText.PushResultTable_columnStatusRepo, (Object)Integer.toString(++i)), 40, 16384);
            statusViewer.getColumn().setToolTipText(uri.toString());
            statusViewer.setLabelProvider((CellLabelProvider)new UpdateStatusLabelProvider(uri));
        }
        this.tableViewer.setInput((Object)result);
        Table table = this.tableViewer.getTable();
        if (table.getItemCount() > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(table.getItem(0).getData()));
        }
        this.tablePanel.layout();
    }

    Control getControl() {
        return this.tablePanel;
    }

    private TableViewerColumn createColumn(TableColumnLayout columnLayout, String text, int weight, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(text);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }

    private class UpdateStatusLabelProvider
    extends ColumnLabelProvider {
        private final URIish uri;

        UpdateStatusLabelProvider(URIish uri) {
            this.uri = uri;
        }

        public String getText(Object element) {
            RefUpdateElement rue = (RefUpdateElement)element;
            if (!rue.isSuccessfulConnection(this.uri)) {
                return UIText.PushResultTable_statusConnectionFailed;
            }
            RemoteRefUpdate rru = rue.getRemoteRefUpdate(this.uri);
            switch (rru.getStatus()) {
                case OK: {
                    if (rru.isDelete()) {
                        return UIText.PushResultTable_statusOkDeleted;
                    }
                    Ref oldRef = rue.getAdvertisedRemoteRef(this.uri);
                    if (oldRef == null) {
                        if (rue.getDstRefName().startsWith("refs/tags/")) {
                            return UIText.PushResultTable_statusOkNewTag;
                        }
                        return UIText.PushResultTable_statusOkNewBranch;
                    }
                    return String.valueOf(this.safeAbbreviate(oldRef.getObjectId())) + (rru.isFastForward() ? ".." : "...") + this.safeAbbreviate(rru.getNewObjectId());
                }
                case UP_TO_DATE: {
                    return UIText.PushResultTable_statusUpToDate;
                }
                case NON_EXISTING: {
                    return UIText.PushResultTable_statusNoMatch;
                }
                case REJECTED_NONFASTFORWARD: 
                case REJECTED_NODELETE: 
                case REJECTED_REMOTE_CHANGED: {
                    return UIText.PushResultTable_statusRejected;
                }
                case REJECTED_OTHER_REASON: {
                    return UIText.PushResultTable_statusRemoteRejected;
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)UIText.PushResultTable_statusUnexpected, (Object)rru.getStatus()));
        }

        private String safeAbbreviate(ObjectId id) {
            String abbrev = (String)PushResultTable.this.abbrevations.get(id);
            if (abbrev == null) {
                try {
                    abbrev = PushResultTable.this.reader.abbreviate((AnyObjectId)id).name();
                }
                catch (IOException iOException) {
                    abbrev = id.name();
                }
                PushResultTable.this.abbrevations.put(id, abbrev);
            }
            return abbrev;
        }

        public Image getImage(Object element) {
            RefUpdateElement rue = (RefUpdateElement)element;
            if (!rue.isSuccessfulConnection(this.uri)) {
                return PushResultTable.this.imageRegistry.get(PushResultTable.IMAGE_DELETE);
            }
            RemoteRefUpdate.Status status = rue.getRemoteRefUpdate(this.uri).getStatus();
            switch (status) {
                case OK: {
                    return null;
                }
                case UP_TO_DATE: 
                case NON_EXISTING: {
                    return null;
                }
                case REJECTED_NONFASTFORWARD: 
                case REJECTED_NODELETE: 
                case REJECTED_REMOTE_CHANGED: 
                case REJECTED_OTHER_REASON: {
                    return PushResultTable.this.imageRegistry.get(PushResultTable.IMAGE_DELETE);
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)UIText.PushResultTable_statusUnexpected, (Object)status));
        }

        public String getToolTipText(Object element) {
            RefUpdateElement rue = (RefUpdateElement)element;
            if (!rue.isSuccessfulConnection(this.uri)) {
                return rue.getErrorMessage(this.uri);
            }
            RemoteRefUpdate rru = rue.getRemoteRefUpdate(this.uri);
            Ref oldRef = rue.getAdvertisedRemoteRef(this.uri);
            switch (rru.getStatus()) {
                case OK: {
                    if (rru.isDelete()) {
                        return NLS.bind((String)UIText.PushResultTable_statusDetailDeleted, (Object)this.safeAbbreviate(oldRef.getObjectId()));
                    }
                    if (oldRef == null) {
                        return null;
                    }
                    if (rru.isFastForward()) {
                        return UIText.PushResultTable_statusDetailFastForward;
                    }
                    return UIText.PushResultTable_statusDetailForcedUpdate;
                }
                case UP_TO_DATE: {
                    return null;
                }
                case NON_EXISTING: {
                    return UIText.PushResultTable_statusDetailNonExisting;
                }
                case REJECTED_NODELETE: {
                    return UIText.PushResultTable_statusDetailNoDelete;
                }
                case REJECTED_NONFASTFORWARD: {
                    return UIText.PushResultTable_statusDetailNonFastForward;
                }
                case REJECTED_REMOTE_CHANGED: {
                    Ref remoteRef = oldRef;
                    String curVal = remoteRef == null ? UIText.PushResultTable_refNonExisting : this.safeAbbreviate(remoteRef.getObjectId());
                    ObjectId expectedOldObjectId = rru.getExpectedOldObjectId();
                    String expVal = expectedOldObjectId.equals((AnyObjectId)ObjectId.zeroId()) ? UIText.PushResultTable_refNonExisting : this.safeAbbreviate(expectedOldObjectId);
                    return NLS.bind((String)UIText.PushResultTable_statusDetailChanged, (Object)curVal, (Object)expVal);
                }
                case REJECTED_OTHER_REASON: {
                    return rru.getMessage();
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)UIText.PushResultTable_statusUnexpected, (Object)rru.getStatus()));
        }
    }
}

