/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.internal.push.RefUpdateElement;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;

class RefUpdateContentProvider
implements IStructuredContentProvider {
    RefUpdateContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            return new RefUpdateElement[0];
        }
        PushOperationResult result = (PushOperationResult)inputElement;
        TreeMap<String, String> dstToSrc = new TreeMap<String, String>();
        for (URIish uri : result.getURIs()) {
            if (!result.isSuccessfulConnection(uri)) continue;
            for (RemoteRefUpdate rru : result.getPushResult(uri).getRemoteUpdates()) {
                dstToSrc.put(rru.getRemoteName(), rru.getSrcRef());
            }
        }
        Object[] elements = new RefUpdateElement[dstToSrc.size()];
        int i = 0;
        for (Map.Entry entry : dstToSrc.entrySet()) {
            elements[i++] = new RefUpdateElement(result, (String)entry.getValue(), (String)entry.getKey());
        }
        return elements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

