/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.merge.GitMergeEditorInput;
import org.eclipse.egit.ui.internal.merge.MergeModeDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RebaseResultDialog
extends MessageDialog {
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private final RebaseResult result;
    private final Repository repo;
    private final Set<String> conflictPaths = new HashSet<String>();
    private Button toggleButton;
    private Button startMergeButton;
    private Button skipCommitButton;
    private Button abortRebaseButton;
    private Button doNothingButton;

    public static void show(final RebaseResult result, final Repository repository) {
        boolean shouldShow;
        boolean bl = shouldShow = result.getStatus() == RebaseResult.Status.STOPPED || !Activator.getDefault().getPreferenceStore().getBoolean("rebase_hide_confirm");
        if (!shouldShow) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, Activator.getPluginId(), NLS.bind((String)UIText.RebaseResultDialog_StatusLabel, (Object)result.getStatus().name())));
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                new RebaseResultDialog(shell, repository, result, null).open();
            }
        });
    }

    private RebaseResultDialog(Shell shell, Repository repository, RebaseResult result) {
        super(shell, UIText.RebaseResultDialog_DialogTitle, INFO, NLS.bind((String)UIText.RebaseResultDialog_StatusLabel, (Object)result.getStatus().name()), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repo = repository;
        this.result = result;
    }

    protected Control createCustomArea(Composite parent) {
        boolean conflictListFailure;
        Group commitGroup;
        Composite main;
        block16: {
            if (this.result.getStatus() != RebaseResult.Status.STOPPED) {
                this.createToggleButton(parent);
                return null;
            }
            main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(1, false));
            GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
            commitGroup = new Group(main, 16);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitGroup);
            commitGroup.setText(UIText.RebaseResultDialog_DetailsGroup);
            commitGroup.setLayout((Layout)new GridLayout(1, false));
            Label commitIdLabel = new Label((Composite)commitGroup, 0);
            commitIdLabel.setText(UIText.RebaseResultDialog_CommitIdLabel);
            Text commitId = new Text((Composite)commitGroup, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)commitId);
            Label commitMessageLabel = new Label((Composite)commitGroup, 0);
            commitMessageLabel.setText(UIText.RebaseResultDialog_CommitMessageLabel);
            TextViewer commitMessage = new TextViewer((Composite)commitGroup, 2826);
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, 60).applyTo(commitMessage.getControl());
            conflictListFailure = false;
            DirCache dc = null;
            RevWalk rw = null;
            try {
                try {
                    rw = new RevWalk(this.repo);
                    RevCommit commit = rw.parseCommit((AnyObjectId)this.result.getCurrentCommit());
                    commitMessage.getTextWidget().setText(commit.getFullMessage());
                    commitId.setText(commit.name());
                    dc = this.repo.lockDirCache();
                    int i = 0;
                    while (i < dc.getEntryCount()) {
                        if (dc.getEntry(i).getStage() > 0) {
                            this.conflictPaths.add(dc.getEntry(i).getPathString());
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    conflictListFailure = true;
                    if (rw != null) {
                        rw.release();
                    }
                    if (dc != null) {
                        dc.unlock();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (rw != null) {
                    rw.release();
                }
                if (dc != null) {
                    dc.unlock();
                }
                throw throwable;
            }
            if (rw != null) {
                rw.release();
            }
            if (dc != null) {
                dc.unlock();
            }
        }
        if (conflictListFailure) {
            Label failureLabel = new Label(main, 0);
            failureLabel.setText(UIText.RebaseResultDialog_ConflictListFailureMessage);
        } else {
            Label conflictListLabel = new Label(main, 0);
            conflictListLabel.setText(UIText.RebaseResultDialog_DiffDetailsLabel);
            TableViewer conflictList = new TableViewer(main, 2048);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)conflictList.getTable());
            conflictList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            conflictList.setInput(this.conflictPaths);
        }
        Group actionGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)actionGroup);
        actionGroup.setText(UIText.RebaseResultDialog_ActionGroupTitle);
        actionGroup.setLayout((Layout)new GridLayout(1, false));
        this.startMergeButton = new Button((Composite)actionGroup, 16);
        this.startMergeButton.setText(UIText.RebaseResultDialog_StartMergeRadioText);
        this.skipCommitButton = new Button((Composite)actionGroup, 16);
        this.skipCommitButton.setText(UIText.RebaseResultDialog_SkipCommitButton);
        this.abortRebaseButton = new Button((Composite)actionGroup, 16);
        this.abortRebaseButton.setText(UIText.RebaseResultDialog_AbortRebaseRadioText);
        this.doNothingButton = new Button((Composite)actionGroup, 16);
        this.doNothingButton.setText(UIText.RebaseResultDialog_DoNothingRadioText);
        this.startMergeButton.setSelection(true);
        commitGroup.pack();
        RebaseResultDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void buttonPressed(int buttonId) {
        if (this.toggleButton != null) {
            Activator.getDefault().getPreferenceStore().setValue("rebase_hide_confirm", this.toggleButton.getSelection());
        }
        if (buttonId == 0) {
            if (this.result.getStatus() != RebaseResult.Status.STOPPED) {
                super.buttonPressed(buttonId);
                return;
            }
            if (this.startMergeButton.getSelection()) {
                GitMergeEditorInput input;
                super.buttonPressed(buttonId);
                ArrayList<IProject> validProjects = new ArrayList<IProject>();
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
                    if (mapping != null && mapping.getRepository().equals(this.repo)) {
                        validProjects.add(project);
                        try {
                            project.refreshLocal(2, null);
                        }
                        catch (CoreException e) {
                            Activator.handleError(e.getMessage(), e, false);
                        }
                    }
                    ++n2;
                }
                ArrayList<IFile> resourceList = new ArrayList<IFile>();
                Path repoWorkdirPath = new Path(this.repo.getWorkTree().getPath());
                for (String repoPath : this.conflictPaths) {
                    IPath filePath = repoWorkdirPath.append(repoPath);
                    for (IProject project : validProjects) {
                        if (!project.getLocation().isPrefixOf(filePath)) continue;
                        IFile res = project.getFile(filePath.removeFirstSegments(project.getLocation().segmentCount()));
                        resourceList.add(res);
                    }
                }
                IResource[] resources = new IResource[resourceList.size()];
                resourceList.toArray(resources);
                int mergeMode = Activator.getDefault().getPreferenceStore().getInt("merge_mode");
                if (mergeMode == 0) {
                    MergeModeDialog dlg = new MergeModeDialog(this.getParentShell());
                    if (dlg.open() != 0) {
                        return;
                    }
                    input = new GitMergeEditorInput(dlg.useWorkspace(), resources);
                } else {
                    boolean useWorkspace = mergeMode == 1;
                    input = new GitMergeEditorInput(useWorkspace, resources);
                }
                CompareUI.openCompareEditor((CompareEditorInput)input);
                return;
            }
            if (this.skipCommitButton.getSelection()) {
                try {
                    RebaseOperation op = new RebaseOperation(this.repo, RebaseCommand.Operation.SKIP);
                    op.execute(null);
                    RebaseResultDialog.show(op.getResult(), this.repo);
                }
                catch (CoreException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            } else if (this.abortRebaseButton.getSelection()) {
                try {
                    RebaseOperation op = new RebaseOperation(this.repo, RebaseCommand.Operation.ABORT);
                    op.execute(null);
                    RebaseResultDialog.show(op.getResult(), this.repo);
                }
                catch (CoreException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            } else {
                this.doNothingButton.getSelection();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void createToggleButton(Composite parent) {
        boolean toggleState = Activator.getDefault().getPreferenceStore().getBoolean("rebase_hide_confirm");
        this.toggleButton = new Button(parent, 16416);
        this.toggleButton.setText(UIText.RebaseResultDialog_ToggleShowButton);
        this.toggleButton.setSelection(toggleState);
    }

    /* synthetic */ RebaseResultDialog(Shell shell, Repository repository, RebaseResult rebaseResult, RebaseResultDialog rebaseResultDialog) {
        this(shell, repository, rebaseResult);
    }
}

