/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.repository.ConfigureUriPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class ConfigureRemoteWizard
extends Wizard {
    final StoredConfig myConfiguration;
    RemoteConfig myRemoteConfiguration;
    final boolean pushMode;
    final String myRemoteName;
    private ConfigureUriPage configureFetchUriPage;
    private RefSpecPage configureFetchSpecPage;
    private ConfigureUriPage configurePushUriPage;
    private RefSpecPage configurePushSpecPage;

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.configureFetchUriPage) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String taskName = NLS.bind((String)UIText.NewRemoteWizard_CheckingUriTaskName, (Object)ConfigureRemoteWizard.this.configureFetchUriPage.getUri().toPrivateString());
                        monitor.beginTask(taskName, -1);
                        ConfigureRemoteWizard.this.configureFetchSpecPage.setSelection(new RepositorySelection(ConfigureRemoteWizard.this.configureFetchUriPage.getUri(), null));
                        ConfigureRemoteWizard.this.configureFetchSpecPage.setCredentials(ConfigureRemoteWizard.this.configureFetchUriPage.getCredentials());
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            catch (InterruptedException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        if (page == this.configurePushUriPage) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String taskName = NLS.bind((String)UIText.NewRemoteWizard_CheckingUriTaskName, (Object)ConfigureRemoteWizard.this.configurePushUriPage.getAllUris().get(0).toPrivateString());
                        monitor.beginTask(taskName, -1);
                        ConfigureRemoteWizard.this.configurePushSpecPage.setSelection(new RepositorySelection(ConfigureRemoteWizard.this.configurePushUriPage.getAllUris().get(0), null));
                        ConfigureRemoteWizard.this.configurePushSpecPage.setCredentials(ConfigureRemoteWizard.this.configurePushUriPage.getCredentials());
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            catch (InterruptedException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return super.getNextPage(page);
    }

    public ConfigureRemoteWizard(Repository repository, String remoteName, boolean push) {
        super.setNeedsProgressMonitor(true);
        this.myConfiguration = repository.getConfig();
        this.myRemoteName = remoteName;
        this.pushMode = push;
        try {
            this.myRemoteConfiguration = new RemoteConfig((Config)this.myConfiguration, remoteName);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.myConfiguration.unsetSection("remote", remoteName);
            try {
                this.myRemoteConfiguration = new RemoteConfig((Config)this.myConfiguration, remoteName);
            }
            catch (URISyntaxException e1) {
                throw new IllegalStateException(e1.getMessage());
            }
        }
        this.configureFetchUriPage = new ConfigureUriPage(true, this.myRemoteConfiguration);
        if (!this.pushMode) {
            this.addPage((IWizardPage)this.configureFetchUriPage);
        }
        this.configureFetchSpecPage = new RefSpecPage(repository, false);
        if (!this.pushMode) {
            this.addPage((IWizardPage)this.configureFetchSpecPage);
        }
        this.configurePushUriPage = new ConfigureUriPage(false, this.myRemoteConfiguration);
        if (this.pushMode) {
            this.addPage((IWizardPage)this.configurePushUriPage);
        }
        this.configurePushSpecPage = new RefSpecPage(repository, true);
        if (this.pushMode) {
            this.addPage((IWizardPage)this.configurePushSpecPage);
        }
        this.setWindowTitle(NLS.bind((String)UIText.ConfigureRemoteWizard_WizardTitle_Change, (Object)this.myRemoteName));
    }

    public StoredConfig getConfiguration() {
        return this.myConfiguration;
    }

    /*
     * Unable to fully structure code
     */
    public boolean performFinish() {
        block5: {
            if (!this.pushMode) ** GOTO lbl14
            while (!this.myRemoteConfiguration.getPushURIs().isEmpty()) {
                this.myRemoteConfiguration.removePushURI((URIish)this.myRemoteConfiguration.getPushURIs().get(0));
            }
            for (URIish uri : this.configurePushUriPage.getUris()) {
                this.myRemoteConfiguration.addPushURI(uri);
            }
            this.myRemoteConfiguration.setPushRefSpecs(this.configurePushSpecPage.getRefSpecs());
            break block5;
lbl-1000:
            // 1 sources

            {
                this.myRemoteConfiguration.removeURI((URIish)this.myRemoteConfiguration.getURIs().get(0));
lbl14:
                // 2 sources

                ** while (!this.myRemoteConfiguration.getURIs().isEmpty())
            }
lbl15:
            // 1 sources

            this.myRemoteConfiguration.addURI(this.configureFetchUriPage.getUri());
            this.myRemoteConfiguration.setFetchRefSpecs(this.configureFetchSpecPage.getRefSpecs());
            this.myRemoteConfiguration.setTagOpt(this.configureFetchSpecPage.getTagOpt());
        }
        this.myRemoteConfiguration.update((Config)this.myConfiguration);
        try {
            this.myConfiguration.save();
            return true;
        }
        catch (IOException v0) {
            return false;
        }
    }
}

