/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.SelectUriWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureUriPage
extends WizardPage {
    private final boolean myFetchMode;
    Text uriText;
    TableViewer tv;
    private URIish myUri;
    private final List<URIish> myUris = new ArrayList<URIish>();
    private final RemoteConfig myConfig;
    private UserPasswordCredentials credentials;

    public ConfigureUriPage(boolean fetchMode, RemoteConfig remoteConfig) {
        super(ConfigureUriPage.class.getName());
        this.myFetchMode = fetchMode;
        this.myConfig = remoteConfig;
        if (fetchMode) {
            this.setTitle(UIText.ConfigureUriPage_ConfigureFetch_pagetitle);
            this.setMessage(UIText.ConfigureUriPage_FetchPageMessage);
        } else {
            this.setTitle(UIText.ConfigureUriPage_ConfigurePush_pagetitle);
            this.setMessage(UIText.ConfigureUriPage_PushPageMessage);
        }
    }

    public void setURI(URIish uri) {
        this.myUri = uri;
        this.uriText.setText(uri.toPrivateString());
        this.checkPage();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        if (this.myFetchMode) {
            main.setLayout((Layout)new GridLayout(3, false));
            Label uriLabel = new Label(main, 0);
            uriLabel.setText(UIText.ConfigureUriPage_FetchUri_label);
            uriLabel.setToolTipText(UIText.ConfigureUriPage_UriTooltip);
            this.uriText = new Text(main, 2048);
            this.uriText.setEnabled(false);
            Button change = new Button(main, 8);
            change.setText(UIText.ConfigureUriPage_Change_button);
            change.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectUriWizard slwz = new SelectUriWizard(false, ConfigureUriPage.this.uriText.getText());
                    WizardDialog dlg = new WizardDialog(ConfigureUriPage.this.getShell(), (IWizard)slwz);
                    dlg.setHelpAvailable(false);
                    if (dlg.open() == 0) {
                        URIish uri = slwz.getUri();
                        ConfigureUriPage.this.credentials = slwz.getCredentials();
                        ConfigureUriPage.this.uriText.setText(uri.toPrivateString());
                        ConfigureUriPage.this.checkPage();
                    }
                }
            });
            if (this.myConfig != null && !this.myConfig.getURIs().isEmpty()) {
                this.uriText.setText(((URIish)this.myConfig.getURIs().get(0)).toPrivateString());
                this.checkPage();
            } else {
                this.setPageComplete(false);
            }
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.uriText);
        } else {
            main.setLayout((Layout)new GridLayout(2, false));
            Label uriLabel = new Label(main, 0);
            uriLabel.setText(UIText.ConfigureUriPage_FetchUri_label);
            uriLabel.setToolTipText(UIText.ConfigureUriPage_UriTooltip);
            this.uriText = new Text(main, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.uriText);
            this.uriText.setEnabled(false);
            Label pushLabel = new Label(main, 0);
            pushLabel.setText(UIText.ConfigureUriPage_PushUriLabel);
            pushLabel.setToolTipText(UIText.ConfigureUriPage_PushUriTooltip);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)pushLabel);
            this.tv = new TableViewer(main);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.tv.getTable());
            this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            Composite buttonBar = new Composite(main, 0);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonBar);
            buttonBar.setLayout((Layout)new RowLayout());
            Button add = new Button(buttonBar, 8);
            add.setText(UIText.ConfigureUriPage_Add_button);
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectUriWizard selectWizard = new SelectUriWizard(false);
                    WizardDialog dlg = new WizardDialog(ConfigureUriPage.this.getShell(), (IWizard)selectWizard);
                    dlg.setHelpAvailable(false);
                    if (dlg.open() == 0) {
                        URIish uri = selectWizard.getUri();
                        if (uri.equals((Object)ConfigureUriPage.this.myUri) || ConfigureUriPage.this.myUris.contains(uri)) {
                            String message = NLS.bind((String)UIText.ConfigureUriPage_DuplicateUriMessage, (Object)uri.toPrivateString());
                            MessageDialog.openInformation((Shell)ConfigureUriPage.this.getShell(), (String)UIText.ConfigureUriPage_DuplicateUriTitle, (String)message);
                            return;
                        }
                        ConfigureUriPage.this.credentials = selectWizard.getCredentials();
                        ConfigureUriPage.this.myUris.add(uri);
                        ConfigureUriPage.this.tv.setInput((Object)ConfigureUriPage.this.myUris);
                        ConfigureUriPage.this.checkPage();
                    }
                }
            });
            final Button change = new Button(buttonBar, 8);
            change.setText(UIText.ConfigureUriPage_Change_button);
            change.setEnabled(false);
            change.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    URIish oldUri = (URIish)((IStructuredSelection)ConfigureUriPage.this.tv.getSelection()).getFirstElement();
                    SelectUriWizard selectWizard = new SelectUriWizard(false, oldUri.toPrivateString());
                    WizardDialog dlg = new WizardDialog(ConfigureUriPage.this.getShell(), (IWizard)selectWizard);
                    dlg.setHelpAvailable(false);
                    if (dlg.open() == 0) {
                        URIish newUri = selectWizard.getUri();
                        if (newUri.equals((Object)ConfigureUriPage.this.myUri) || ConfigureUriPage.this.myUris.contains(newUri)) {
                            String message = NLS.bind((String)UIText.ConfigureUriPage_DuplicateUriMessage, (Object)newUri.toPrivateString());
                            MessageDialog.openInformation((Shell)ConfigureUriPage.this.getShell(), (String)UIText.ConfigureUriPage_DuplicateUriTitle, (String)message);
                            return;
                        }
                        int index = ConfigureUriPage.this.myUris.indexOf(oldUri);
                        if (index > -1) {
                            ConfigureUriPage.this.myUris.remove(oldUri);
                            ConfigureUriPage.this.myUris.add(index, newUri);
                        } else {
                            ConfigureUriPage.this.myUris.add(newUri);
                        }
                        ConfigureUriPage.this.credentials = selectWizard.getCredentials();
                        ConfigureUriPage.this.tv.setInput((Object)ConfigureUriPage.this.myUris);
                        ConfigureUriPage.this.checkPage();
                    }
                }
            });
            final Button remove = new Button(buttonBar, 8);
            remove.setText(UIText.ConfigureUriPage_Remove_button);
            remove.setEnabled(false);
            remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] objectArray = ((IStructuredSelection)ConfigureUriPage.this.tv.getSelection()).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        ConfigureUriPage.this.myUris.remove(o);
                        ++n2;
                    }
                    ConfigureUriPage.this.tv.setInput((Object)ConfigureUriPage.this.myUris);
                    ConfigureUriPage.this.checkPage();
                }
            });
            this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)ConfigureUriPage.this.tv.getSelection();
                    remove.setEnabled(!sel.isEmpty());
                    change.setEnabled(sel.size() == 1);
                }
            });
            this.tv.getControl().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (ConfigureUriPage.this.tv.getTable().getSelection().length == 0 && ConfigureUriPage.this.tv.getTable().getItemCount() > 0) {
                        ConfigureUriPage.this.tv.setSelection((ISelection)new StructuredSelection((Object)ConfigureUriPage.this.tv.getTable().getItem(0)));
                    }
                }
            });
            if (this.myConfig != null) {
                if (!this.myConfig.getURIs().isEmpty()) {
                    this.myUri = (URIish)this.myConfig.getURIs().get(0);
                    this.uriText.setText(this.myUri.toPrivateString());
                }
                for (URIish uri : this.myConfig.getPushURIs()) {
                    this.myUris.add(uri);
                }
                this.tv.setInput(this.myUris);
                this.checkPage();
            } else {
                this.setPageComplete(false);
            }
        }
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPage() {
        block9: {
            block8: {
                try {
                    this.setErrorMessage(null);
                    if (this.myFetchMode) {
                        if (this.uriText.getText().equals("")) {
                            this.setErrorMessage(UIText.ConfigureUriPage_MissingUri_message);
                            break block8;
                        }
                        try {
                            this.myUri = new URIish(this.uriText.getText());
                            break block9;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            this.setErrorMessage(UIText.ConfigureUriPage_ParsingProblem_message);
                            this.setPageComplete(this.getErrorMessage() == null);
                            return;
                        }
                    }
                    if (this.myUri != null || !this.myUris.isEmpty()) break block9;
                    this.setErrorMessage(UIText.ConfigureUriPage_MissingUris_message);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public URIish getUri() {
        if (this.myFetchMode) {
            return this.myUri;
        }
        throw new IllegalStateException();
    }

    public List<URIish> getUris() {
        if (this.myFetchMode) {
            throw new IllegalStateException();
        }
        return this.myUris;
    }

    public List<URIish> getAllUris() {
        if (this.myFetchMode) {
            throw new IllegalStateException();
        }
        ArrayList<URIish> uris = new ArrayList<URIish>();
        uris.addAll(this.myUris);
        if (uris.isEmpty()) {
            uris.add(this.myUri);
        }
        return uris;
    }

    public UserPasswordCredentials getCredentials() {
        return this.credentials;
    }

    private static final class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((URIish)element).toPrivateString();
        }
    }
}

