/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.CreateBranchPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class CreateBranchWizard
extends Wizard {
    private String newBranchName;
    private CreateBranchPage myPage;

    public CreateBranchWizard(Repository repository, Ref baseBranch) {
        this.myPage = new CreateBranchPage(repository, baseBranch);
        this.setWindowTitle(UIText.CreateBranchWizard_NewBranchTitle);
    }

    public CreateBranchWizard(Repository repository, RevCommit baseCommit) {
        this.myPage = new CreateBranchPage(repository, baseCommit);
        this.setWindowTitle(UIText.CreateBranchWizard_NewBranchTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CreateBranchPage cp = (CreateBranchPage)CreateBranchWizard.this.getPages()[0];
                    try {
                        CreateBranchWizard.this.newBranchName = cp.getBranchName();
                        cp.createBranch(monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                    catch (IOException ioe) {
                        throw new InvocationTargetException(ioe);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            Activator.handleError(UIText.CreateBranchWizard_CreationFailed, ite.getCause(), true);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public String getNewBranchName() {
        return this.newBranchName;
    }
}

