/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.repository.ConfigureUriPage;
import org.eclipse.egit.ui.internal.repository.SelectRemoteNamePage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class NewRemoteWizard
extends Wizard {
    final StoredConfig myConfiguration;
    private SelectRemoteNamePage selNamePage;
    private ConfigureUriPage configureFetchUriPage;
    private RefSpecPage configureFetchSpecPage;
    private ConfigureUriPage configurePushUriPage;
    private RefSpecPage configurePushSpecPage;

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selNamePage) {
            if (this.selNamePage.configureFetch.getSelection()) {
                return this.configureFetchUriPage;
            }
            if (this.selNamePage.configurePush.getSelection()) {
                return this.configurePushUriPage;
            }
        }
        if (page == this.configureFetchSpecPage) {
            if (!this.selNamePage.configurePush.getSelection()) {
                return null;
            }
            this.configurePushUriPage.setURI(this.configureFetchUriPage.getUri());
        }
        if (page == this.configureFetchUriPage) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String taskName = NLS.bind((String)UIText.NewRemoteWizard_CheckingUriTaskName, (Object)NewRemoteWizard.this.configureFetchUriPage.getUri().toPrivateString());
                        monitor.beginTask(taskName, -1);
                        NewRemoteWizard.this.configureFetchSpecPage.setSelection(new RepositorySelection(NewRemoteWizard.this.configureFetchUriPage.getUri(), null));
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            catch (InterruptedException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        if (page == this.configurePushUriPage) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String taskName = NLS.bind((String)UIText.NewRemoteWizard_CheckingUriTaskName, (Object)NewRemoteWizard.this.configurePushUriPage.getAllUris().get(0).toPrivateString());
                        monitor.beginTask(taskName, -1);
                        NewRemoteWizard.this.configurePushSpecPage.setSelection(new RepositorySelection(NewRemoteWizard.this.configurePushUriPage.getAllUris().get(0), null));
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            catch (InterruptedException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.selNamePage.isPageComplete()) {
            boolean complete = true;
            if (this.selNamePage.configureFetch.getSelection()) {
                boolean bl = complete = complete && this.configureFetchSpecPage.isPageComplete();
            }
            if (this.selNamePage.configurePush.getSelection()) {
                complete = complete && this.configurePushSpecPage.isPageComplete();
            }
            return complete;
        }
        return super.canFinish();
    }

    public NewRemoteWizard(Repository repository) {
        super.setNeedsProgressMonitor(true);
        this.myConfiguration = repository.getConfig();
        this.selNamePage = new SelectRemoteNamePage();
        this.addPage((IWizardPage)this.selNamePage);
        this.configureFetchUriPage = new ConfigureUriPage(true, null);
        this.addPage((IWizardPage)this.configureFetchUriPage);
        this.configureFetchSpecPage = new RefSpecPage(repository, false);
        this.addPage((IWizardPage)this.configureFetchSpecPage);
        this.configurePushUriPage = new ConfigureUriPage(false, null);
        this.addPage((IWizardPage)this.configurePushUriPage);
        this.configurePushSpecPage = new RefSpecPage(repository, true);
        this.addPage((IWizardPage)this.configurePushSpecPage);
        this.setWindowTitle(UIText.ConfigureRemoteWizard_WizardTitle_New);
    }

    public StoredConfig getConfiguration() {
        return this.myConfiguration;
    }

    public boolean performFinish() {
        RemoteConfig config;
        try {
            config = new RemoteConfig((Config)this.myConfiguration, this.selNamePage.remoteName.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        if (this.selNamePage.configureFetch.getSelection()) {
            config.addURI(this.configureFetchUriPage.getUri());
            config.setFetchRefSpecs(this.configureFetchSpecPage.getRefSpecs());
            config.setTagOpt(this.configureFetchSpecPage.getTagOpt());
        }
        if (this.selNamePage.configurePush.getSelection()) {
            for (URIish uri : this.configurePushUriPage.getUris()) {
                config.addPushURI(uri);
            }
            config.setPushRefSpecs(this.configurePushSpecPage.getRefSpecs());
        }
        config.update((Config)this.myConfiguration);
        try {
            this.myConfiguration.save();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

