/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RepositoriesViewLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Map<Image, Image> decoratedImages = new HashMap<Image, Image>();

    public Image getImage(Object element) {
        return this.decorateImage(((RepositoryTreeNode)element).getType().getIcon(), element);
    }

    public String getText(Object element) {
        if (!(element instanceof RepositoryTreeNode)) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        return this.getSimpleText(node);
    }

    public void dispose() {
        for (Image image : this.decoratedImages.values()) {
            image.dispose();
        }
        this.decoratedImages.clear();
        super.dispose();
    }

    /*
     * Unable to fully structure code
     */
    private Image decorateImage(Image image, Object element) {
        node = (RepositoryTreeNode)element;
        switch (RepositoriesViewLabelProvider.$SWITCH_TABLE$org$eclipse$egit$ui$internal$repository$tree$RepositoryTreeNodeType()[node.getType().ordinal()]) {
            case 3: 
            case 9: 
            case 10: {
                refName = ((Ref)node.getObject()).getName();
                leaf = ((Ref)node.getObject()).getLeaf();
                try {
                    branchName = node.getRepository().getFullBranch();
                    if (branchName == null) {
                        return image;
                    }
                    if (!refName.startsWith("refs/heads/")) ** GOTO lbl13
                    compareString = refName;
                    ** GOTO lbl39
lbl13:
                    // 1 sources

                    if (!refName.startsWith("refs/tags/")) ** GOTO lbl21
                    id = node.getRepository().resolve(refName);
                    if (id == null) {
                        return image;
                    }
                    rw = new RevWalk(node.getRepository());
                    tag = rw.parseTag((AnyObjectId)id);
                    compareString = tag.getObject().name();
                    ** GOTO lbl39
lbl21:
                    // 1 sources

                    if (!refName.startsWith("refs/remotes/")) ** GOTO lbl29
                    id = node.getRepository().resolve(refName);
                    if (id == null) {
                        return image;
                    }
                    rw = new RevWalk(node.getRepository());
                    commit = rw.parseCommit((AnyObjectId)id);
                    compareString = commit.getId().name();
                    ** GOTO lbl39
lbl29:
                    // 1 sources

                    if (refName.equals("HEAD")) {
                        return this.getDecoratedImage(image);
                    }
                    leafname = leaf.getName();
                    if (leafname.startsWith("refs/") && leafname.equals(node.getRepository().getFullBranch())) {
                        return this.getDecoratedImage(image);
                    }
                    if (leaf.getObjectId().equals((AnyObjectId)node.getRepository().resolve("HEAD"))) {
                        return this.getDecoratedImage(image);
                    }
                    return image;
                }
                catch (IOException v0) {
                    return image;
                }
lbl39:
                // 3 sources

                if (compareString.equals(branchName)) {
                    return this.getDecoratedImage(image);
                }
                return image;
            }
        }
        return image;
    }

    private Image getDecoratedImage(final Image image) {
        Image decoratedImage = this.decoratedImages.get(image);
        if (decoratedImage == null) {
            CompositeImageDescriptor cd = new CompositeImageDescriptor(){

                protected Point getSize() {
                    Rectangle bounds = image.getBounds();
                    return new Point(bounds.width, bounds.height);
                }

                protected void drawCompositeImage(int width, int height) {
                    this.drawImage(image.getImageData(), 0, 0);
                    this.drawImage(UIIcons.OVR_CHECKEDOUT.getImageData(), 0, 0);
                }
            };
            decoratedImage = cd.createImage();
            this.decoratedImages.put(image, decoratedImage);
        }
        return decoratedImage;
    }

    public StyledString getStyledText(Object element) {
        if (!(element instanceof RepositoryTreeNode)) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        try {
            switch (node.getType()) {
                case REPO: {
                    Repository repository = (Repository)node.getObject();
                    File directory = repository.getDirectory();
                    StyledString string = new StyledString(directory.getParentFile().getName());
                    string.append(" - " + directory.getAbsolutePath(), StyledString.QUALIFIER_STYLER);
                    String branch = repository.getBranch();
                    if (repository.getRepositoryState() != RepositoryState.SAFE) {
                        branch = String.valueOf(branch) + " - " + repository.getRepositoryState().getDescription();
                    }
                    string.append(" [" + branch + "]", StyledString.DECORATIONS_STYLER);
                    return string;
                }
                case ADDITIONALREF: {
                    Ref ref = (Ref)node.getObject();
                    StyledString refName = new StyledString(Repository.shortenRefName((String)ref.getName()));
                    if (ref.isSymbolic()) {
                        refName.append(" - ", StyledString.QUALIFIER_STYLER);
                        refName.append(ref.getLeaf().getName(), StyledString.QUALIFIER_STYLER);
                        refName.append(" - ", StyledString.QUALIFIER_STYLER);
                        refName.append(ObjectId.toString((ObjectId)ref.getLeaf().getObjectId()), StyledString.QUALIFIER_STYLER);
                    } else {
                        refName.append(" - ", StyledString.QUALIFIER_STYLER);
                        refName.append(ObjectId.toString((ObjectId)ref.getObjectId()), StyledString.QUALIFIER_STYLER);
                    }
                    return refName;
                }
                case WORKINGDIR: {
                    StyledString dirString = new StyledString(UIText.RepositoriesView_WorkingDir_treenode);
                    dirString.append(" - ", StyledString.QUALIFIER_STYLER);
                    if (node.getRepository().isBare()) {
                        dirString.append(UIText.RepositoriesViewLabelProvider_BareRepositoryMessage, StyledString.QUALIFIER_STYLER);
                    } else {
                        dirString.append(node.getRepository().getWorkTree().getAbsolutePath(), StyledString.QUALIFIER_STYLER);
                    }
                    return dirString;
                }
                case BRANCHES: 
                case REF: 
                case LOCAL: 
                case BRANCHHIERARCHY: 
                case REMOTETRACKING: 
                case TAGS: 
                case ADDITIONALREFS: 
                case TAG: 
                case FILE: 
                case FOLDER: 
                case REMOTES: 
                case REMOTE: 
                case FETCH: 
                case PUSH: 
                case ERROR: {
                    String label = this.getSimpleText(node);
                    if (label != null) {
                        return new StyledString(label);
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getSimpleText(RepositoryTreeNode node) {
        switch (node.getType()) {
            case REPO: {
                File directory = ((Repository)node.getObject()).getDirectory();
                StringBuilder sb = new StringBuilder();
                sb.append(directory.getParentFile().getName());
                sb.append(" - ");
                sb.append(directory.getAbsolutePath());
                return sb.toString();
            }
            case FILE: 
            case FOLDER: {
                return ((File)node.getObject()).getName();
            }
            case BRANCHES: {
                return UIText.RepositoriesView_Branches_Nodetext;
            }
            case LOCAL: {
                return UIText.RepositoriesViewLabelProvider_LocalNodetext;
            }
            case REMOTETRACKING: {
                return UIText.RepositoriesViewLabelProvider_RemoteTrackingNodetext;
            }
            case BRANCHHIERARCHY: {
                IPath fullPath = (IPath)node.getObject();
                return fullPath.lastSegment();
            }
            case TAGS: {
                return UIText.RepositoriesViewLabelProvider_TagsNodeText;
            }
            case ADDITIONALREFS: {
                return UIText.RepositoriesViewLabelProvider_SymbolicRefNodeText;
            }
            case REMOTES: {
                return UIText.RepositoriesView_RemotesNodeText;
            }
            case REF: 
            case TAG: {
                Ref ref = (Ref)node.getObject();
                String refName = Repository.shortenRefName((String)ref.getName());
                if (node.getParent().getType() == RepositoryTreeNodeType.BRANCHHIERARCHY) {
                    int index = refName.lastIndexOf(47);
                    refName = refName.substring(index + 1);
                }
                return refName;
            }
            case ADDITIONALREF: {
                Ref ref = (Ref)node.getObject();
                String refName = Repository.shortenRefName((String)ref.getName());
                refName = ref.isSymbolic() ? String.valueOf(refName) + " - " + ref.getLeaf().getName() + " - " + ObjectId.toString((ObjectId)ref.getLeaf().getObjectId()) : String.valueOf(refName) + " - " + ObjectId.toString((ObjectId)ref.getObjectId());
                return refName;
            }
            case WORKINGDIR: {
                if (node.getRepository().isBare()) {
                    return String.valueOf(UIText.RepositoriesView_WorkingDir_treenode) + " - " + UIText.RepositoriesViewLabelProvider_BareRepositoryMessage;
                }
                return String.valueOf(UIText.RepositoriesView_WorkingDir_treenode) + " - " + node.getRepository().getWorkTree().getAbsolutePath();
            }
            case REMOTE: 
            case FETCH: 
            case PUSH: 
            case ERROR: {
                return (String)node.getObject();
            }
        }
        return null;
    }
}

