/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import org.eclipse.egit.ui.internal.repository.RepositoryPropertySource;
import org.eclipse.egit.ui.internal.repository.RepositoryRemotePropertySource;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoryPropertySourceProvider
implements IPropertySourceProvider {
    private final PropertySheetPage myPage;
    private Object lastObject;
    private IPropertySource lastRepositorySource;

    public RepositoryPropertySourceProvider(PropertySheetPage page) {
        this.myPage = page;
    }

    public IPropertySource getPropertySource(Object object) {
        if (object == this.lastObject) {
            return this.lastRepositorySource;
        }
        if (!(object instanceof RepositoryTreeNode)) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)object;
        if (node.getType() == RepositoryTreeNodeType.REPO) {
            this.lastObject = object;
            this.lastRepositorySource = new RepositoryPropertySource((Repository)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        if (node.getType() == RepositoryTreeNodeType.REMOTE) {
            this.lastObject = object;
            this.lastRepositorySource = new RepositoryRemotePropertySource(node.getRepository().getConfig(), (String)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        if (node.getType() == RepositoryTreeNodeType.FETCH || node.getType() == RepositoryTreeNodeType.PUSH) {
            return this.getPropertySource(node.getParent());
        }
        return null;
    }
}

