/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.FilteredCheckboxTree;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySearchDialog
extends TitleAreaDialog {
    private static final String PREF_DEEP_SEARCH = "RepositorySearchDialogDeepSearch";
    private static final String PREF_PATH = "RepositorySearchDialogSearchPath";
    private final Set<String> fExistingDirectories = new HashSet<String>();
    private Set<String> fResult;
    private FilteredCheckboxTree fTree;
    private CachedCheckboxTreeViewer fTreeViewer;
    private Text dir;
    private Button lookForNestedButton;
    private Button searchButton;
    private Button toggleSelectionButton;
    private final ResourceManager fImageCache = new LocalResourceManager(JFaceResources.getResources());
    private final IEclipsePreferences prefs = new InstanceScope().getNode(org.eclipse.egit.core.Activator.getPluginId());

    public RepositorySearchDialog(Shell parentShell, Collection<String> existingDirs) {
        super(parentShell);
        this.fExistingDirectories.addAll(existingDirs);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.setHelpAvailable(false);
    }

    public Set<String> getDirectories() {
        return this.fResult;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.RepositorySearchDialog_AddGitRepositories);
        this.setTitleImage(this.fImageCache.createImage(UIIcons.WIZBAN_IMPORT_REPO));
    }

    protected void okPressed() {
        this.fResult = new HashSet<String>();
        this.fResult.addAll(this.getCheckedItems());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite titleParent = (Composite)super.createDialogArea(parent);
        this.setTitle(UIText.RepositorySearchDialog_SearchTitle);
        this.setMessage(UIText.RepositorySearchDialog_searchRepositoriesMessage);
        Composite main = new Composite(titleParent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Group searchGroup = new Group(main, 16);
        searchGroup.setText(UIText.RepositorySearchDialog_SearchCriteriaGroup);
        searchGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchGroup);
        Label dirLabel = new Label((Composite)searchGroup, 0);
        dirLabel.setText(UIText.RepositorySearchDialog_directory);
        this.dir = new Text((Composite)searchGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(300, -1).applyTo((Control)this.dir);
        this.dir.setToolTipText(UIText.RepositorySearchDialog_EnterDirectoryToolTip);
        String initialPath = this.prefs.get(PREF_PATH, FS.DETECTED.userHome().toString());
        this.dir.setText(initialPath);
        Button browse = new Button((Composite)searchGroup, 8);
        browse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        browse.setText(UIText.RepositorySearchDialog_browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(RepositorySearchDialog.this.getShell());
                dd.setFilterPath(RepositorySearchDialog.this.dir.getText());
                String directory = dd.open();
                if (directory != null) {
                    RepositorySearchDialog.this.setNeedsSearch();
                    RepositorySearchDialog.this.dir.setText(directory);
                    RepositorySearchDialog.this.prefs.put(RepositorySearchDialog.PREF_PATH, directory);
                    try {
                        RepositorySearchDialog.this.prefs.flush();
                    }
                    catch (BackingStoreException backingStoreException) {}
                }
            }
        });
        this.lookForNestedButton = new Button((Composite)searchGroup, 32);
        this.lookForNestedButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.lookForNestedButton.setSelection(this.prefs.getBoolean(PREF_DEEP_SEARCH, false));
        this.lookForNestedButton.setText(UIText.RepositorySearchDialog_DeepSearch_button);
        this.lookForNestedButton.setToolTipText(UIText.RepositorySearchDialog_SearchRecursiveToolTip);
        this.lookForNestedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.prefs.putBoolean(RepositorySearchDialog.PREF_DEEP_SEARCH, RepositorySearchDialog.this.lookForNestedButton.getSelection());
                try {
                    RepositorySearchDialog.this.prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
                RepositorySearchDialog.this.setNeedsSearch();
            }
        });
        this.searchButton = new Button((Composite)searchGroup, 8);
        GridDataFactory.fillDefaults().span(3, 1).align(1, 4).applyTo((Control)this.searchButton);
        this.searchButton.setText(UIText.RepositorySearchDialog_Search);
        this.searchButton.setToolTipText(UIText.RepositorySearchDialog_SearchTooltip);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySearchDialog.this.doSearch();
            }
        });
        Group searchResultGroup = new Group(main, 16);
        searchResultGroup.setText(UIText.RepositorySearchDialog_SearchResultGroup);
        searchResultGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().applyTo((Control)searchResultGroup);
        PatternFilter filter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                if (RepositorySearchDialog.this.getCheckedItems().contains(element)) {
                    return true;
                }
                return super.isElementVisible(viewer, element);
            }
        };
        this.fTree = new FilteredCheckboxTree((Composite)searchResultGroup, null, 0, filter);
        this.fTreeViewer = this.fTree.getCheckboxTreeViewer();
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RepositorySearchDialog.this.enableOk();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).minSize(0, 300).applyTo((Control)this.fTree);
        Composite buttonColumn = new Composite((Composite)searchResultGroup, 0);
        buttonColumn.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)buttonColumn);
        this.toggleSelectionButton = new Button(buttonColumn, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.toggleSelectionButton);
        this.toggleSelectionButton.setText(UIText.RepositorySearchDialog_ToggleSelectionButton);
        this.toggleSelectionButton.setEnabled(false);
        this.toggleSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = RepositorySearchDialog.this.fTreeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    RepositorySearchDialog.this.fTreeViewer.setChecked(item.getData(), !item.getChecked());
                    ++n2;
                }
                RepositorySearchDialog.this.enableOk();
            }
        });
        this.dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySearchDialog.this.setNeedsSearch();
            }
        });
        this.fTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        RepositorySearchDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableOk();
    }

    private void findGitDirsRecursive(File root, Set<String> strings, IProgressMonitor monitor, boolean lookForNestedRepositories) {
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (child.isDirectory() && RepositoryCache.FileKey.isGitRepository((File)child, (FS)FS.DETECTED)) {
                try {
                    strings.add(child.getCanonicalPath());
                }
                catch (IOException iOException) {}
                monitor.setTaskName(NLS.bind((String)UIText.RepositorySearchDialog_RepositoriesFound_message, (Object)strings.size()));
                if (!lookForNestedRepositories) {
                    return;
                }
            } else if (child.isDirectory()) {
                monitor.subTask(child.getPath());
                this.findGitDirsRecursive(child, strings, monitor, lookForNestedRepositories);
            }
            ++n2;
        }
    }

    private HashSet<String> getCheckedItems() {
        HashSet<String> ret = new HashSet<String>();
        Object[] objectArray = this.fTreeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            ret.add((String)item);
            ++n2;
        }
        return ret;
    }

    private void doSearch() {
        this.setMessage(null);
        this.setErrorMessage(null);
        final HashSet directories = new HashSet();
        final File file = new File(this.dir.getText());
        final boolean lookForNested = this.lookForNestedButton.getSelection();
        if (file.exists()) {
            try {
                this.prefs.put(PREF_PATH, file.getCanonicalPath());
                try {
                    this.prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            catch (IOException iOException) {}
            IRunnableWithProgress action = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        RepositorySearchDialog.this.findGitDirsRecursive(file, directories, monitor, lookForNested);
                    }
                    catch (Exception ex) {
                        org.eclipse.egit.core.Activator.getDefault().getLog().log((IStatus)new Status(4, org.eclipse.egit.core.Activator.getPluginId(), ex.getMessage(), (Throwable)ex));
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                ProgressMonitorDialog pd = new ProgressMonitorDialog(this.getShell());
                pd.getProgressMonitor().setTaskName(UIText.RepositorySearchDialog_ScanningForRepositories_message);
                pd.run(true, true, action);
            }
            catch (InvocationTargetException e1) {
                Activator.handleError(UIText.RepositorySearchDialog_errorOccurred, e1, true);
            }
            catch (InterruptedException interruptedException) {}
            int foundOld = 0;
            TreeSet<String> validDirs = new TreeSet<String>();
            for (String foundDir : directories) {
                if (!this.fExistingDirectories.contains(foundDir)) {
                    validDirs.add(foundDir);
                    continue;
                }
                ++foundOld;
            }
            if (foundOld > 0) {
                String message = NLS.bind((String)UIText.RepositorySearchDialog_SomeDirectoriesHiddenMessage, (Object)foundOld);
                this.setMessage(message, 1);
            } else if (directories.isEmpty()) {
                this.setMessage(UIText.RepositorySearchDialog_NothingFoundMessage, 1);
            }
            this.toggleSelectionButton.setEnabled(!validDirs.isEmpty());
            this.fTree.clearFilter();
            this.fTreeViewer.setInput(validDirs);
            this.fTreeViewer.setAllChecked(true);
            this.enableOk();
        }
    }

    private void setNeedsSearch() {
        this.fTreeViewer.setInput(null);
        File file = new File(this.dir.getText());
        if (!file.exists()) {
            this.setErrorMessage(NLS.bind((String)UIText.RepositorySearchDialog_DirectoryNotFoundMessage, (Object)this.dir.getText()));
        } else {
            this.setErrorMessage(null);
            this.setMessage(UIText.RepositorySearchDialog_NoSearchAvailableMessage, 1);
        }
        this.enableOk();
    }

    private void enableOk() {
        boolean enable = this.fTreeViewer.getCheckedElements().length > 0;
        this.getButton(0).setEnabled(enable);
        if (enable) {
            this.getButton(0).setFocus();
        }
    }

    private static final class ContentProvider
    implements ITreeContentProvider {
        private final Object[] children = new Object[0];

        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Set)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private final class RepositoryLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private RepositoryLabelProvider() {
        }

        public Image getImage(Object element) {
            return RepositorySearchDialog.this.fImageCache.createImage(UIIcons.REPOSITORY);
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (RepositorySearchDialog.this.fExistingDirectories.contains(element)) {
                return RepositorySearchDialog.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }

        public void dispose() {
            RepositorySearchDialog.this.fImageCache.dispose();
        }
    }
}

