/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchHierarchyNode
extends RepositoryTreeNode<IPath> {
    public BranchHierarchyNode(RepositoryTreeNode parent, Repository repository, IPath path) {
        super(parent, RepositoryTreeNodeType.BRANCHHIERARCHY, repository, path);
    }

    public List<IPath> getChildPaths() throws IOException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (IPath myPath : this.getPathList()) {
            IPath newPath;
            int segmentDiff;
            if (!((IPath)this.getObject()).isPrefixOf(myPath) || (segmentDiff = myPath.segmentCount() - ((IPath)this.getObject()).segmentCount()) <= 1 || result.contains(newPath = ((IPath)this.getObject()).append(myPath.segment(((IPath)this.getObject()).segmentCount())))) continue;
            result.add(newPath);
        }
        return result;
    }

    public List<Ref> getChildRefs() throws IOException {
        ArrayList<Ref> childRefs = new ArrayList<Ref>();
        for (IPath myPath : this.getPathList()) {
            int segmentDiff;
            if (!((IPath)this.getObject()).isPrefixOf(myPath) || (segmentDiff = myPath.segmentCount() - ((IPath)this.getObject()).segmentCount()) != 1) continue;
            Ref ref = this.getRepository().getRef(myPath.toPortableString());
            childRefs.add(ref);
        }
        return childRefs;
    }

    private List<IPath> getPathList() throws IOException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        Map refsMap = this.getRepository().getRefDatabase().getRefs(((IPath)this.getObject()).toPortableString());
        for (Map.Entry entry : refsMap.entrySet()) {
            if (((Ref)entry.getValue()).isSymbolic()) continue;
            result.add(((IPath)this.getObject()).append((IPath)new Path((String)entry.getKey())));
        }
        return result;
    }
}

