/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonActionProvider;

public class RepositoriesViewActionProvider
extends CommonActionProvider {
    private IAction copyAction;
    private IAction pasteAction;

    public void fillActionBars(IActionBars actionBars) {
        IStructuredSelection sel;
        if (this.pasteAction == null) {
            this.pasteAction = new Action(""){

                public void run() {
                    IHandlerService srv = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    ICommandService csrv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command openCommand = csrv.getCommand("org.eclipse.egit.ui.RepositoriesViewPaste");
                    ExecutionEvent evt = srv.createExecutionEvent(openCommand, null);
                    try {
                        openCommand.executeWithChecks(evt);
                    }
                    catch (Exception e) {
                        Activator.handleError(e.getMessage(), e, true);
                    }
                }
            };
        }
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteAction);
        if (this.copyAction == null) {
            this.copyAction = new Action(""){

                public void run() {
                    IHandlerService srv = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    ICommandService csrv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command openCommand = csrv.getCommand("org.eclipse.egit.ui.RepositoriesViewCopyPath");
                    ExecutionEvent evt = srv.createExecutionEvent(openCommand, null);
                    try {
                        openCommand.executeWithChecks(evt);
                    }
                    catch (Exception e) {
                        Activator.handleError(e.getMessage(), e, true);
                    }
                }
            };
        }
        if ((sel = (IStructuredSelection)this.getActionSite().getViewSite().getSelectionProvider().getSelection()).size() == 1) {
            RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
            if (node.getType() == RepositoryTreeNodeType.REPO || node.getType() == RepositoryTreeNodeType.FILE || node.getType() == RepositoryTreeNodeType.FOLDER) {
                this.copyAction.setEnabled(true);
            } else if (node.getType() == RepositoryTreeNodeType.WORKINGDIR) {
                boolean isBare = node.getRepository().isBare();
                this.copyAction.setEnabled(!isBare);
            } else {
                this.copyAction.setEnabled(false);
            }
        }
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
    }
}

