/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.File;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryTreeNode<T>
implements Comparable<RepositoryTreeNode> {
    private final Repository myRepository;
    private final T myObject;
    private final RepositoryTreeNodeType myType;
    private final RepositoryTreeNode myParent;

    public RepositoryTreeNode(RepositoryTreeNode parent, RepositoryTreeNodeType type, Repository repository, T treeObject) {
        this.myParent = parent;
        this.myRepository = repository;
        this.myType = type;
        this.myObject = treeObject;
    }

    public RepositoryTreeNode getParent() {
        return this.myParent;
    }

    public RepositoryTreeNodeType getType() {
        return this.myType;
    }

    public Repository getRepository() {
        return this.myRepository;
    }

    public T getObject() {
        return this.myObject;
    }

    public int hashCode() {
        int result = 1;
        switch (this.myType) {
            case REPO: 
            case BRANCHES: 
            case LOCAL: 
            case REMOTETRACKING: 
            case ADDITIONALREFS: 
            case REMOTES: 
            case WORKINGDIR: {
                result = 31 * result + (this.myObject == null ? 0 : ((Repository)this.myObject).getDirectory().hashCode());
                break;
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: {
                result = 31 * result + (this.myObject == null ? 0 : ((Ref)this.myObject).getName().hashCode());
                break;
            }
            case FILE: 
            case FOLDER: {
                result = 31 * result + (this.myObject == null ? 0 : ((File)this.myObject).getPath().hashCode());
                break;
            }
            case BRANCHHIERARCHY: 
            case TAGS: 
            case REMOTE: 
            case FETCH: 
            case PUSH: 
            case ERROR: {
                result = 31 * result + (this.myObject == null ? 0 : this.myObject.hashCode());
            }
        }
        result = 31 * result + (this.myParent == null ? 0 : this.myParent.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.getDirectory().hashCode());
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryTreeNode other = (RepositoryTreeNode)obj;
        if (this.myType == null ? other.myType != null : !this.myType.equals((Object)other.myType)) {
            return false;
        }
        if (this.myParent == null ? other.myParent != null : !this.myParent.equals(other.myParent)) {
            return false;
        }
        if (this.myRepository == null ? other.myRepository != null : !this.myRepository.getDirectory().equals(other.myRepository.getDirectory())) {
            return false;
        }
        return !(this.myObject == null ? other.myObject != null : !this.checkObjectsEqual(other.myObject));
    }

    @Override
    public int compareTo(RepositoryTreeNode otherNode) {
        int typeDiff = this.myType.ordinal() - otherNode.getType().ordinal();
        if (typeDiff != 0) {
            return typeDiff;
        }
        switch (this.myType) {
            case BRANCHES: 
            case LOCAL: 
            case BRANCHHIERARCHY: 
            case REMOTETRACKING: {
                return this.myObject.toString().compareTo(otherNode.getObject().toString());
            }
            case TAGS: 
            case ADDITIONALREFS: 
            case REMOTES: 
            case WORKINGDIR: 
            case ERROR: {
                return 0;
            }
            case REMOTE: 
            case FETCH: 
            case PUSH: {
                return ((String)this.myObject).compareTo((String)otherNode.getObject());
            }
            case FILE: 
            case FOLDER: {
                return ((File)this.myObject).getName().compareTo(((File)otherNode.getObject()).getName());
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: {
                return ((Ref)this.myObject).getName().compareTo(((Ref)otherNode.getObject()).getName());
            }
            case REPO: {
                int nameCompare = ((Repository)this.myObject).getDirectory().getParentFile().getName().compareTo(((Repository)otherNode.getObject()).getDirectory().getParentFile().getName());
                if (nameCompare != 0) {
                    return nameCompare;
                }
                return ((Repository)this.myObject).getDirectory().getParentFile().getParentFile().getPath().compareTo(((Repository)otherNode.getObject()).getDirectory().getParentFile().getParentFile().getPath());
            }
        }
        return 0;
    }

    private boolean checkObjectsEqual(Object otherObject) {
        switch (this.myType) {
            case REPO: 
            case BRANCHES: 
            case LOCAL: 
            case REMOTETRACKING: 
            case ADDITIONALREFS: 
            case REMOTES: 
            case WORKINGDIR: 
            case ERROR: {
                return ((Repository)this.myObject).getDirectory().equals(((Repository)otherObject).getDirectory());
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: {
                return ((Ref)this.myObject).getName().equals(((Ref)otherObject).getName());
            }
            case FILE: 
            case FOLDER: {
                return ((File)this.myObject).getPath().equals(((File)otherObject).getPath());
            }
            case BRANCHHIERARCHY: 
            case TAGS: 
            case REMOTE: 
            case FETCH: 
            case PUSH: {
                return this.myObject.equals(otherObject);
            }
        }
        return false;
    }
}

