/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.rebase.RebaseResultDialog;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRebaseCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    private final RebaseCommand.Operation operation;
    private final String jobname;
    private final String dialogMessage;

    protected AbstractRebaseCommand(RebaseCommand.Operation operation, String jobname, String dialogMessage) {
        this.operation = operation;
        this.jobname = jobname;
        this.dialogMessage = dialogMessage;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        final Repository repository = node.getRepository();
        final RebaseOperation rebase = new RebaseOperation(repository, this.operation);
        Job job = new Job(this.jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    rebase.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(rebase.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                IStatus result = cevent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.AbstractRebaseCommand_DialogTitle, (String)AbstractRebaseCommand.this.dialogMessage);
                        }
                    });
                } else if (result.isOK()) {
                    RebaseResultDialog.show(rebase.getResult(), repository);
                }
            }
        });
        job.schedule();
        return null;
    }
}

