/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBranchCommand
extends RepositoriesViewCommandHandler<RefNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List nodes = this.getSelectedNodes(event);
        final ArrayList unmergedNodes = new ArrayList();
        final Shell shell = this.getShell(event);
        try {
            new ProgressMonitorDialog(shell).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        BranchMessageDialog messageDialog;
                        for (RefNode refNode : nodes) {
                            int result = DeleteBranchCommand.this.deleteBranch(refNode, (Ref)refNode.getObject(), false);
                            if (result == 1) {
                                throw new CoreException(Activator.createErrorStatus(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null));
                            }
                            if (result != 2) continue;
                            unmergedNodes.add(refNode);
                        }
                        if (!unmergedNodes.isEmpty() && (messageDialog = new BranchMessageDialog(shell, unmergedNodes)).open() == 0) {
                            for (RefNode node : unmergedNodes) {
                                DeleteBranchCommand.this.deleteBranch(node, (Ref)node.getObject(), true);
                            }
                        }
                    }
                    catch (CoreException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private int deleteBranch(RefNode node, Ref ref, boolean force) throws CoreException {
        DeleteBranchOperation dbop = new DeleteBranchOperation(node.getRepository(), ref, force);
        dbop.execute(null);
        return dbop.getStatus();
    }

    private static final class BranchLabelProvider
    extends LabelProvider {
        private BranchLabelProvider() {
        }

        public String getText(Object element) {
            RefNode refNode = (RefNode)element;
            return ((Ref)refNode.getObject()).getName();
        }

        public Image getImage(Object element) {
            return RepositoryTreeNodeType.REF.getIcon();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BranchMessageDialog
    extends MessageDialog {
        private final List<RefNode> nodes;

        private BranchMessageDialog(Shell parentShell, List<RefNode> nodes) {
            super(parentShell, UIText.RepositoriesView_ConfirmDeleteTitle, null, UIText.RepositoriesView_ConfirmBranchDeletionMessage, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.nodes = nodes;
        }

        protected Control createCustomArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setLayoutData((Object)new GridData(1808));
            area.setLayout((Layout)new FillLayout());
            TableViewer branchesList = new TableViewer(area);
            branchesList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            branchesList.setLabelProvider((IBaseLabelProvider)new BranchLabelProvider());
            branchesList.setInput(this.nodes);
            return area;
        }
    }
}

