/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.MergeTargetSelectionDialog;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String targetRef;
        String refName;
        Repository repository;
        block10: {
            BasicConfigurationDialog.show();
            RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
            repository = node.getRepository();
            if (!this.canMerge(repository)) {
                return null;
            }
            if (node instanceof RefNode) {
                refName = ((Ref)((RefNode)node).getObject()).getName();
                try {
                    if (repository.getFullBranch().equals(refName)) {
                        targetRef = null;
                        break block10;
                    }
                    targetRef = refName;
                }
                catch (IOException iOException) {
                    targetRef = null;
                }
            } else {
                targetRef = node instanceof TagNode ? ((Ref)((TagNode)node).getObject()).getName() : null;
            }
        }
        if (targetRef != null) {
            refName = targetRef;
        } else {
            MergeTargetSelectionDialog mergeTargetSelectionDialog = new MergeTargetSelectionDialog(this.getShell(event), repository);
            if (mergeTargetSelectionDialog.open() == 0) {
                refName = mergeTargetSelectionDialog.getRefName();
            } else {
                return null;
            }
        }
        String jobname = NLS.bind((String)UIText.MergeAction_JobNameMerge, (Object)refName);
        final MergeOperation op = new MergeOperation(repository, refName);
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent jobEvent) {
                IStatus result = jobEvent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.MergeAction_MergeCanceledTitle, (String)UIText.MergeAction_MergeCanceledMessage);
                        }
                    });
                } else if (!result.isOK()) {
                    Activator.handleError(result.getMessage(), result.getException(), true);
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            new MergeResultDialog(shell, repository, op.getResult()).open();
                        }
                    });
                }
            }
        });
        job.schedule();
        return null;
    }

    private boolean canMerge(Repository repository) {
        String message = null;
        IOException ex = null;
        try {
            Ref head = repository.getRef("HEAD");
            if (head == null || !head.isSymbolic()) {
                message = UIText.MergeAction_HeadIsNoBranch;
            } else if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                message = NLS.bind((String)UIText.MergeAction_WrongRepositoryState, (Object)repository.getRepositoryState());
            }
        }
        catch (IOException e) {
            message = e.getMessage();
            ex = e;
        }
        if (message != null) {
            Activator.handleError(UIText.MergeAction_CannotMerge, ex, true);
        }
        return message == null;
    }
}

