/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.pull.PullResultDialog;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullCommand
extends RepositoriesViewCommandHandler<RepositoryNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String branchName;
        final Repository repository = ((RepositoryNode)this.getSelectedNodes(event).get(0)).getRepository();
        if (repository == null) {
            return null;
        }
        try {
            branchName = repository.getBranch();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        String jobname = NLS.bind((String)UIText.PullCurrentBranchActionHandler_PullJobname, (Object)branchName);
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        final PullOperation pull = new PullOperation(repository, timeout);
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    pull.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(pull.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                IStatus result = cevent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.PullCurrentBranchActionHandler_PullCanceledTitle, (String)UIText.PullCurrentBranchActionHandler_PullCanceledMessage);
                        }
                    });
                } else if (result.isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            new PullResultDialog(shell, repository, pull.getResult()).open();
                        }
                    });
                }
            }
        });
        job.schedule();
        return null;
    }
}

