/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.egit.ui.internal.repository.tree.PushNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushConfiguredRemoteCommand
extends RepositoriesViewCommandHandler<PushNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        RemoteConfig config = null;
        if (node instanceof PushNode) {
            try {
                RemoteNode remote = (RemoteNode)node.getParent();
                config = new RemoteConfig((Config)node.getRepository().getConfig(), (String)remote.getObject());
            }
            catch (URISyntaxException e) {
                throw new ExecutionException(e.getMessage());
            }
        } else if (node instanceof RepositoryNode) {
            config = SimpleConfigurePushDialog.getConfiguredRemote(node.getRepository());
        }
        if (config == null) {
            MessageDialog.openInformation((Shell)this.getShell(event), (String)UIText.SimplePushActionHandler_NothingToPushDialogTitle, (String)UIText.SimplePushActionHandler_NothingToPushDialogMessage);
            return null;
        }
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        new PushOperationUI(node.getRepository(), config, timeout, false).start();
        return null;
    }
}

