/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.RebaseTargetSelectionDialog;
import org.eclipse.egit.ui.internal.rebase.RebaseHelper;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseCurrentRefCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Ref ref;
        BasicConfigurationDialog.show();
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        Repository repository = node.getRepository();
        if (node instanceof RefNode) {
            ref = (Ref)((RefNode)node).getObject();
        } else {
            RebaseTargetSelectionDialog rebaseTargetSelectionDialog = new RebaseTargetSelectionDialog(this.getShell(event), repository);
            if (rebaseTargetSelectionDialog.open() == 0) {
                String refName = rebaseTargetSelectionDialog.getRefName();
                try {
                    ref = repository.getRef(refName);
                }
                catch (IOException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            } else {
                return null;
            }
        }
        String jobname = NLS.bind((String)UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, (Object)ref.getName());
        RebaseHelper.runRebaseJob(repository, jobname, ref);
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext ctx;
        Object selection;
        if (evaluationContext instanceof IEvaluationContext && (selection = (ctx = (IEvaluationContext)evaluationContext).getVariable("activeMenuSelection")) instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.getFirstElement() instanceof RefNode) {
                this.setBaseEnabled(((RefNode)((IStructuredSelection)selection).getFirstElement()).getRepository().getRepositoryState() == RepositoryState.SAFE);
            }
            return;
        }
        this.setBaseEnabled(true);
    }
}

