/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.command.DeleteRepositoryConfirmDialog;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCommand
extends RepositoriesViewCommandHandler<RepositoryNode>
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.removeRepository(event, false);
        return null;
    }

    protected void removeRepository(final ExecutionEvent event, final boolean delete) {
        List selectedNodes;
        IWorkbenchSite activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)activeSite.getService(IWorkbenchSiteProgressService.class);
        try {
            selectedNodes = this.getSelectedNodes(event);
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, true);
            return;
        }
        boolean deleteWorkingDir = false;
        if (delete) {
            if (selectedNodes.size() > 1) {
                return;
            }
            if (selectedNodes.size() == 1) {
                Repository repository = (Repository)((RepositoryNode)selectedNodes.get(0)).getObject();
                if (repository.isBare()) {
                    String title = UIText.RemoveCommand_ConfirmDeleteBareRepositoryTitle;
                    String message = NLS.bind((String)UIText.RemoveCommand_ConfirmDeleteBareRepositoryMessage, (Object)repository.getDirectory().getPath());
                    if (!MessageDialog.openConfirm((Shell)this.getShell(event), (String)title, (String)message)) {
                        return;
                    }
                } else {
                    DeleteRepositoryConfirmDialog dlg = new DeleteRepositoryConfirmDialog(this.getShell(event), repository);
                    if (dlg.open() != 0) {
                        return;
                    }
                    deleteWorkingDir = dlg.shouldDeleteWorkingDir();
                }
            }
        }
        final boolean deleteWorkDir = deleteWorkingDir;
        Job job = new Job("Remove Repositories Job"){

            protected IStatus run(IProgressMonitor monitor) {
                final ArrayList<IProject> projectsToDelete = new ArrayList<IProject>();
                monitor.setTaskName(UIText.RepositoriesView_DeleteRepoDeterminProjectsMessage);
                for (RepositoryNode node : selectedNodes) {
                    if (node.getRepository().isBare()) continue;
                    File workDir = node.getRepository().getWorkTree();
                    Path wdPath = new Path(workDir.getAbsolutePath());
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject prj = iProjectArray[n2];
                        if (monitor.isCanceled()) {
                            return Status.OK_STATUS;
                        }
                        if (wdPath.isPrefixOf(prj.getLocation())) {
                            projectsToDelete.add(prj);
                        }
                        ++n2;
                    }
                }
                final boolean[] confirmedCanceled = new boolean[2];
                if (!projectsToDelete.isEmpty()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                confirmedCanceled[0] = RemoveCommand.this.confirmProjectDeletion(projectsToDelete, event);
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                confirmedCanceled[1] = true;
                            }
                        }
                    });
                }
                if (confirmedCanceled[1]) {
                    return Status.OK_STATUS;
                }
                if (confirmedCanceled[0]) {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor actMonitor) throws CoreException {
                            for (IProject prj : projectsToDelete) {
                                prj.delete(false, false, actMonitor);
                            }
                        }
                    };
                    try {
                        ResourcesPlugin.getWorkspace().run(wsr, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
                    }
                    catch (CoreException e1) {
                        Activator.logError(e1.getMessage(), e1);
                    }
                }
                for (RepositoryNode node : selectedNodes) {
                    RemoveCommand.this.util.removeDir(node.getRepository().getDirectory());
                }
                if (delete) {
                    try {
                        for (RepositoryNode node : selectedNodes) {
                            Repository repo = node.getRepository();
                            if (!repo.isBare() && deleteWorkDir) {
                                FileUtils.delete((File)repo.getWorkTree(), (int)3);
                            }
                            FileUtils.delete((File)repo.getDirectory(), (int)7);
                        }
                    }
                    catch (IOException e) {
                        return Activator.createErrorStatus(e.getMessage(), e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        service.schedule(job);
    }

    private boolean confirmProjectDeletion(List<IProject> projectsToDelete, ExecutionEvent event) throws OperationCanceledException {
        String message = NLS.bind((String)UIText.RepositoriesView_ConfirmProjectDeletion_Question, (Object)projectsToDelete.size());
        MessageDialog dlg = new MessageDialog(this.getShell(event), UIText.RepositoriesView_ConfirmProjectDeletion_WindowTitle, null, message, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int index = dlg.open();
        if (index == 2) {
            throw new OperationCanceledException();
        }
        return index == 0;
    }
}

