/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.sharing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.sharing.SharingWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExistingOrNewPage
extends WizardPage {
    private final SharingWizard myWizard;
    private Button button;
    private Tree tree;
    private CheckboxTreeViewer viewer;
    private Text repositoryToCreate;
    private IPath minumumPath;
    private Text dotGitSegment;

    ExistingOrNewPage(SharingWizard w) {
        super(ExistingOrNewPage.class.getName());
        this.setTitle(UIText.ExistingOrNewPage_title);
        this.setDescription(UIText.ExistingOrNewPage_description);
        this.setImageDescriptor(UIIcons.WIZBAN_CONNECT_REPO);
        this.myWizard = w;
    }

    public void createControl(Composite parent) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(3, false));
        g.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tree = new Tree((Composite)g, 67618);
        this.viewer = new CheckboxTreeViewer(this.tree);
        this.tree.setHeaderVisible(true);
        this.tree.setLayout((Layout)new GridLayout());
        this.tree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).create());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectAndRepo checkable = (ProjectAndRepo)event.getElement();
                    TreeItem[] treeItemArray = ExistingOrNewPage.this.tree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem ti = treeItemArray[n2];
                        if (ti.getItemCount() > 0 || ((ProjectAndRepo)ti.getData()).getRepo().equals("")) {
                            ti.setChecked(false);
                        }
                        TreeItem[] treeItemArray2 = ti.getItems();
                        int n3 = treeItemArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeItem subTi = treeItemArray2[n4];
                            IProject project = ((ProjectAndRepo)subTi.getData()).getProject();
                            if (checkable.getProject() != null && !subTi.getData().equals(checkable) && checkable.getProject().equals((Object)project)) {
                                subTi.setChecked(false);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        });
        TreeColumn c1 = new TreeColumn(this.tree, 0);
        c1.setText(UIText.ExistingOrNewPage_HeaderProject);
        c1.setWidth(100);
        TreeColumn c2 = new TreeColumn(this.tree, 0);
        c2.setText(UIText.ExistingOrNewPage_HeaderPath);
        c2.setWidth(400);
        TreeColumn c3 = new TreeColumn(this.tree, 0);
        c3.setText(UIText.ExistingOrNewPage_HeaderRepository);
        c3.setWidth(200);
        IProject[] iProjectArray = this.myWizard.projects;
        int n = this.myWizard.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryFinder repositoryFinder = new RepositoryFinder(project);
            try {
                TreeItem treeItem;
                RepositoryMapping m;
                Collection mappings = repositoryFinder.find((IProgressMonitor)new NullProgressMonitor());
                Iterator mi = mappings.iterator();
                RepositoryMapping repositoryMapping = m = mi.hasNext() ? (RepositoryMapping)mi.next() : null;
                if (m == null) {
                    treeItem = new TreeItem(this.tree, 0);
                    treeItem.setText(0, project.getName());
                    treeItem.setText(1, project.getLocation().toOSString());
                    treeItem.setText(2, "");
                    treeItem.setData((Object)new ProjectAndRepo(project, ""));
                } else if (!mi.hasNext()) {
                    treeItem = new TreeItem(this.tree, 0);
                    treeItem.setText(0, project.getName());
                    treeItem.setText(1, project.getLocation().toOSString());
                    this.fillTreeItemWithGitDirectory(m, treeItem, false);
                    treeItem.setData((Object)new ProjectAndRepo(project, treeItem.getText(2)));
                    treeItem.setChecked(true);
                } else {
                    treeItem = new TreeItem(this.tree, 0);
                    treeItem.setText(0, project.getName());
                    treeItem.setText(1, project.getLocation().toOSString());
                    treeItem.setData((Object)new ProjectAndRepo(null, null));
                    TreeItem treeItem2 = new TreeItem(treeItem, 0);
                    treeItem2.setText(0, project.getName());
                    this.fillTreeItemWithGitDirectory(m, treeItem2, true);
                    treeItem2.setData((Object)new ProjectAndRepo(project, treeItem2.getText(2)));
                    while (mi.hasNext()) {
                        m = (RepositoryMapping)mi.next();
                        treeItem2 = new TreeItem(treeItem, 0);
                        treeItem2.setText(0, project.getName());
                        this.fillTreeItemWithGitDirectory(m, treeItem2, true);
                        treeItem2.setData((Object)new ProjectAndRepo(m.getContainer().getProject(), treeItem2.getText(2)));
                    }
                    treeItem.setExpanded(true);
                }
            }
            catch (CoreException e) {
                TreeItem treeItem2 = new TreeItem(this.tree, 3);
                treeItem2.setText(e.getMessage());
            }
            ++n2;
        }
        this.button = new Button((Composite)g, 8);
        this.button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.button.setText(UIText.ExistingOrNewPage_CreateButton);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg;
                File gitDir = new File(ExistingOrNewPage.this.repositoryToCreate.getText(), ".git");
                try {
                    FileRepository repository = new FileRepository(gitDir);
                    repository.create();
                    for (IProject project : ExistingOrNewPage.this.getProjects(false).keySet()) {
                        if (gitDir.toString().contains("..")) continue;
                        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
                    util.addConfiguredRepository(gitDir);
                }
                catch (IOException e1) {
                    msg = NLS.bind((String)UIText.ExistingOrNewPage_ErrorFailedToCreateRepository, (Object)gitDir.toString());
                    Activator.handleError(msg, e1, true);
                }
                catch (CoreException e2) {
                    msg = NLS.bind((String)UIText.ExistingOrNewPage_ErrorFailedToRefreshRepository, (Object)gitDir);
                    Activator.handleError(msg, e2, true);
                }
                TreeItem[] treeItemArray = ExistingOrNewPage.this.tree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    ti.setText(2, gitDir.toString());
                    ((ProjectAndRepo)ti.getData()).repo = gitDir.toString();
                    ti.setChecked(true);
                    ++n2;
                }
                ExistingOrNewPage.this.updateCreateOptions();
                ExistingOrNewPage.this.getContainer().updateButtons();
            }
        });
        this.repositoryToCreate = new Text((Composite)g, 2052);
        this.repositoryToCreate.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(1, 1).create());
        this.repositoryToCreate.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (ExistingOrNewPage.this.repositoryToCreate.getText().equals("")) {
                    ExistingOrNewPage.this.button.setEnabled(false);
                    return;
                }
                IPath fromOSString = Path.fromOSString((String)ExistingOrNewPage.this.repositoryToCreate.getText());
                ExistingOrNewPage.this.button.setEnabled(ExistingOrNewPage.this.minumumPath.matchingFirstSegments(fromOSString) == fromOSString.segmentCount());
            }
        });
        this.dotGitSegment = new Text((Composite)g, 0);
        this.dotGitSegment.setEnabled(false);
        this.dotGitSegment.setEditable(false);
        this.dotGitSegment.setText(String.valueOf(File.separatorChar) + ".git");
        this.dotGitSegment.setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 0x1000000).create());
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExistingOrNewPage.this.tree.select((TreeItem)e.item);
                ExistingOrNewPage.this.updateCreateOptions();
            }
        });
        this.updateCreateOptions();
        Dialog.applyDialogFont((Control)g);
        this.setControl((Control)g);
    }

    private void fillTreeItemWithGitDirectory(RepositoryMapping m, TreeItem treeItem, boolean isAlternative) {
        if (m.getGitDir() == null) {
            treeItem.setText(2, UIText.ExistingOrNewPage_SymbolicValueEmptyMapping);
        } else {
            IPath container = m.getContainerPath();
            if (!container.isEmpty()) {
                container = Path.fromOSString((String)".");
            }
            IPath relativePath = container.append(m.getGitDir());
            if (isAlternative) {
                IPath withoutLastSegment = relativePath.removeLastSegments(1);
                IPath path = withoutLastSegment.isEmpty() ? Path.fromPortableString((String)".") : withoutLastSegment;
                treeItem.setText(0, path.toString());
            }
            treeItem.setText(2, relativePath.toOSString());
            try {
                IProject project = m.getContainer().getProject();
                FileRepository repo = new FileRepository(m.getGitDirAbsolutePath().toFile());
                File workTree = repo.getWorkTree();
                IPath workTreePath = Path.fromOSString((String)workTree.getAbsolutePath());
                if (workTreePath.isPrefixOf(project.getLocation())) {
                    IPath makeRelativeTo = project.getLocation().makeRelativeTo(workTreePath);
                    String repoRelativePath = makeRelativeTo.append("/.project").toPortableString();
                    ObjectId headCommitId = repo.resolve("HEAD");
                    if (headCommitId != null) {
                        RevWalk revWalk = new RevWalk((Repository)repo);
                        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headCommitId);
                        RevTree headTree = headCommit.getTree();
                        TreeWalk projectInRepo = TreeWalk.forPath((Repository)repo, (String)repoRelativePath, (RevTree)headTree);
                        if (projectInRepo != null) {
                            treeItem.setChecked(true);
                        }
                        revWalk.dispose();
                    }
                }
                repo.close();
            }
            catch (IOException e1) {
                Activator.logError("Failed to detect which repository to use", e1);
            }
        }
    }

    private void updateCreateOptions() {
        this.minumumPath = null;
        IPath p = null;
        TreeItem[] treeItemArray = this.tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            if (ti.getItemCount() <= 0) {
                String path = ti.getText(2);
                if (!path.equals("")) {
                    p = null;
                    break;
                }
                String gitDirParentCandidate = ti.getText(1);
                IPath thisPath = Path.fromOSString((String)gitDirParentCandidate);
                if (p == null) {
                    p = thisPath;
                } else {
                    int n3 = p.matchingFirstSegments(thisPath);
                    p = p.removeLastSegments(p.segmentCount() - n3);
                }
            }
            ++n2;
        }
        this.minumumPath = p;
        if (p != null) {
            this.repositoryToCreate.setText(p.toOSString());
        } else {
            this.repositoryToCreate.setText("");
        }
        this.button.setEnabled(p != null);
        this.repositoryToCreate.setEnabled(p != null);
        this.dotGitSegment.setEnabled(p != null);
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        if (this.viewer.getCheckedElements().length == 0) {
            return false;
        }
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            String path = ((ProjectAndRepo)checkedElement).getRepo();
            if (((ProjectAndRepo)checkedElement).getRepo() != null && path.equals("")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Map<IProject, File> getProjects(boolean checked) {
        ISelection selection;
        Object[] elements = checked ? this.viewer.getCheckedElements() : ((selection = this.viewer.getSelection()) instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : new Object[]{});
        HashMap<IProject, File> ret = new HashMap<IProject, File>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IPath selectedRepo;
            Object ti = objectArray[n2];
            IProject project = ((ProjectAndRepo)ti).getProject();
            String path = ((ProjectAndRepo)ti).getRepo();
            IPath localPathToRepo = selectedRepo = Path.fromOSString((String)path);
            if (!selectedRepo.isAbsolute()) {
                localPathToRepo = project.getLocation().append(selectedRepo);
            }
            ret.put(project, localPathToRepo.toFile());
            ++n2;
        }
        return ret;
    }

    private static class ProjectAndRepo {
        private IProject project;
        private String repo;

        public ProjectAndRepo(IProject project, String repo) {
            this.project = project;
            this.repo = repo;
        }

        public IProject getProject() {
            return this.project;
        }

        public String getRepo() {
            return this.repo;
        }
    }
}

