/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.sharing;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.sharing.ExistingOrNewPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IWorkbench;

public class SharingWizard
extends Wizard
implements IConfigurationWizard,
IConfigurationWizardExtension {
    IProject[] projects;
    private ExistingOrNewPage existingPage;

    public SharingWizard() {
        this.setWindowTitle(UIText.SharingWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
        ConfigurationChecker.checkConfiguration();
    }

    public void init(IWorkbench workbench, IProject[] p) {
        this.projects = new IProject[p.length];
        System.arraycopy(p, 0, this.projects, 0, p.length);
    }

    public void init(IWorkbench workbench, IProject p) {
        this.projects = new IProject[]{p};
    }

    public void addPages() {
        this.existingPage = new ExistingOrNewPage(this);
        this.addPage((IWizardPage)this.existingPage);
    }

    public boolean performFinish() {
        final ConnectProviderOperation op = new ConnectProviderOperation(this.existingPage.getProjects(true));
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        op.execute(monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof CoreException) {
                IStatus status = ((CoreException)e).getStatus();
                e = status.getException();
            }
            Activator.handleError(UIText.SharingWizard_failed, e, true);
            return false;
        }
    }

    public boolean canFinish() {
        return this.existingPage.isPageComplete();
    }
}

