/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.synchronize.GitChangeSetModelProvider;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class GitModelSynchronizeParticipant
extends ModelSynchronizeParticipant {
    public static final String ID = "org.eclipse.egit.ui.modelCompareParticipant";
    public static final String VIEWER_ID = "org.eclipse.egit.ui.compareSynchronization";
    private static final String WORKSPACE_MODEL_PROVIDER_ID = "org.eclipse.core.resources.modelProvider";
    private final GitSynchronizeDataSet gsds;

    public GitModelSynchronizeParticipant(GitSubscriberMergeContext context) {
        super((SynchronizationContext)context);
        this.gsds = context.getSyncData();
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        configuration.setProperty("org.eclipse.team.ui.activeModelProvider", (Object)"org.eclipse.egit.ui.changeSetModel");
        super.initializeConfiguration(configuration);
    }

    public ModelProvider[] getEnabledModelProviders() {
        ArrayList<ModelProvider> providers = new ArrayList<ModelProvider>();
        ModelProvider[] avaliableProviders = super.getEnabledModelProviders();
        if (!this.includeResourceModelProvider()) {
            ModelProvider[] modelProviderArray = avaliableProviders;
            int n = avaliableProviders.length;
            int n2 = 0;
            while (n2 < n) {
                ModelProvider provider = modelProviderArray[n2];
                if (provider.getId().equals(WORKSPACE_MODEL_PROVIDER_ID)) {
                    providers.add(provider);
                    break;
                }
                ++n2;
            }
            providers.add(GitChangeSetModelProvider.getProvider());
        } else {
            boolean addGitProvider = true;
            ModelProvider[] modelProviderArray = avaliableProviders;
            int n = avaliableProviders.length;
            int n3 = 0;
            while (n3 < n) {
                ModelProvider provider = modelProviderArray[n3];
                String providerId = provider.getId();
                providers.add(provider);
                if (addGitProvider && providerId.equals("org.eclipse.egit.ui.changeSetModel")) {
                    addGitProvider = false;
                }
                ++n3;
            }
            if (addGitProvider) {
                providers.add(GitChangeSetModelProvider.getProvider());
            }
        }
        return providers.toArray(new ModelProvider[providers.size()]);
    }

    public boolean hasCompareInputFor(Object object) {
        return object instanceof GitModelBlob;
    }

    public ICompareInput asCompareInput(Object object) {
        IFile file;
        GitSynchronizeData gsd;
        if (object instanceof IFile && !(gsd = this.gsds.getData((file = (IFile)object).getProject())).shouldIncludeLocal()) {
            return this.getFileFromGit(gsd, file.getLocation());
        }
        return super.asCompareInput(object);
    }

    private boolean includeResourceModelProvider() {
        GitSubscriberMergeContext context = (GitSubscriberMergeContext)this.getContext();
        for (GitSynchronizeData gsd : context.getSyncData()) {
            if (gsd.shouldIncludeLocal()) continue;
            return false;
        }
        return true;
    }

    private ICompareInput getFileFromGit(GitSynchronizeData gsd, IPath location) {
        Repository repo = gsd.getRepository();
        File workTree = repo.getWorkTree();
        String repoRelativeLocation = Repository.stripWorkDir((File)workTree, (File)location.toFile());
        TreeWalk tw = new TreeWalk(repo);
        tw.setRecursive(true);
        tw.setFilter((TreeFilter)PathFilter.create((String)repoRelativeLocation.toString()));
        RevCommit baseCommit = gsd.getSrcRevCommit();
        RevCommit remoteCommit = gsd.getDstRevCommit();
        try {
            int baseNth = tw.addTree((AnyObjectId)baseCommit.getTree());
            int remoteNth = tw.addTree((AnyObjectId)remoteCommit.getTree());
            if (tw.next()) {
                ComparisonDataSource baseData = new ComparisonDataSource(baseCommit, tw.getObjectId(baseNth));
                ComparisonDataSource remoteData = new ComparisonDataSource(remoteCommit, tw.getObjectId(remoteNth));
                return new GitCompareInput(repo, baseData, baseData, remoteData, repoRelativeLocation);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return null;
    }
}

