/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.CommitAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class GitSubscriberParticipant
extends SubscriberParticipant {
    public static final String PARTICIPANT_NAME = "org.eclipse.egit.ui.synchronizeParticipant";

    public GitSubscriberParticipant(GitSynchronizeDataSet data) {
        this.setSubscriber((Subscriber)new GitResourceVariantTreeSubscriber(data));
        this.setName(data.toString());
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.addActionContribution(new SynchronizePageActionGroup(){

            public void initialize(ISynchronizePageConfiguration pageConfiguration) {
                super.initialize(pageConfiguration);
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "synchronize", (IAction)new CommitAction(pageConfiguration));
            }
        });
        configuration.setSupportedModes(15);
        configuration.setMode(4);
    }

    public String getId() {
        return PARTICIPANT_NAME;
    }

    public String getSecondaryId() {
        return "secondaryId";
    }

    public void refresh(GitSynchronizeDataSet data) {
        this.refresh((IResource[])data.getAllProjects(), UIText.GitSynchronizeWizard_gitResourceSynchronization, null, null);
    }

    void reset(GitSynchronizeDataSet data) {
        GitResourceVariantTreeSubscriber subscriber = (GitResourceVariantTreeSubscriber)this.getSubscriber();
        subscriber.reset(data);
        this.setName(data.toString());
        this.reset();
    }
}

