/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.synchronize.GitSubscriberParticipant;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;

public class GitSynchronize {
    public GitSynchronize(GitSynchronizeData data) {
        this(new GitSynchronizeDataSet(data));
    }

    public GitSynchronize(GitSynchronizeDataSet data) {
        GitSubscriberParticipant participant = this.getParticipant(data);
        participant.refresh(data);
    }

    private GitSubscriberParticipant getParticipant(GitSynchronizeDataSet data) {
        GitSubscriberParticipant participant;
        ISynchronizeManager synchronizeManager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipantReference[] participants = synchronizeManager.get("org.eclipse.egit.ui.synchronizeParticipant");
        if (participants.length == 0) {
            participant = this.createDefaultParticipant(data);
        } else {
            try {
                participant = (GitSubscriberParticipant)participants[0].getParticipant();
                participant.reset(data);
            }
            catch (TeamException teamException) {
                participant = this.createDefaultParticipant(data);
            }
        }
        return participant;
    }

    private GitSubscriberParticipant createDefaultParticipant(GitSynchronizeDataSet data) {
        GitSubscriberParticipant participant = new GitSubscriberParticipant(data);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        return participant;
    }
}

