/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitSynchronizeWizardPage
extends WizardPage {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private CheckboxTreeViewer treeViewer;
    private Map<Repository, Set<IProject>> repositories;
    private Set<Repository> selectedRepositories = new HashSet<Repository>();
    private Set<IProject> selectedProjects = new HashSet<IProject>();
    private Map<Repository, String> selectedBranches = new HashMap<Repository, String>();
    private Image branchesImage = UIIcons.BRANCHES.createImage();
    private Image repositoryImage = UIIcons.REPOSITORY.createImage();

    GitSynchronizeWizardPage() {
        super(GitSynchronizeWizardPage.class.getName());
        this.setTitle(UIText.GitBranchSynchronizeWizardPage_title);
        this.setDescription(UIText.GitBranchSynchronizeWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.repositories = new HashMap<Repository, Set<IProject>>();
        IProject[] iProjectArray = ROOT.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping != null) {
                Repository repository = mapping.getRepository();
                Set<IProject> set = this.repositories.get(repository);
                if (set == null) {
                    set = new HashSet<IProject>();
                    this.repositories.put(repository, set);
                }
                set.add(project);
            }
            ++n2;
        }
        this.treeViewer = new ContainerCheckedTreeViewer(composite, 68352);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewerColumn repositoriesColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        repositoriesColumn.getColumn().setText(UIText.GitBranchSynchronizeWizardPage_repositories);
        repositoriesColumn.getColumn().setImage(this.repositoryImage);
        repositoriesColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Repository) {
                    return ((Repository)element).getDirectory().getAbsolutePath();
                }
                return ((IProject)element).getName();
            }

            public Image getImage(Object element) {
                if (element instanceof Repository) {
                    return GitSynchronizeWizardPage.this.repositoryImage;
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
        });
        TreeViewerColumn branchesColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384);
        branchesColumn.getColumn().setText(UIText.GitBranchSynchronizeWizardPage_branches);
        branchesColumn.getColumn().setImage(this.branchesImage);
        branchesColumn.getColumn().setWidth(200);
        final ComboBoxCellEditor branchesEditor = new ComboBoxCellEditor((Composite)this.treeViewer.getTree(), new String[0]);
        branchesColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                int intValue = (Integer)value;
                if (intValue == -1) {
                    return;
                }
                CCombo combo = (CCombo)branchesEditor.getControl();
                String branch = combo.getItem(intValue);
                if (element instanceof IProject) {
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)element));
                    Repository repository = mapping.getRepository();
                    GitSynchronizeWizardPage.this.selectedBranches.put(repository, branch);
                    GitSynchronizeWizardPage.this.treeViewer.refresh((Object)repository, true);
                } else {
                    GitSynchronizeWizardPage.this.selectedBranches.put((Repository)element, branch);
                    GitSynchronizeWizardPage.this.treeViewer.refresh(element, true);
                }
                GitSynchronizeWizardPage.this.setPageComplete(GitSynchronizeWizardPage.this.selectedBranches.size() == GitSynchronizeWizardPage.this.selectedRepositories.size());
            }

            protected Object getValue(Object element) {
                if (element instanceof IProject) {
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)element));
                    String branch = (String)GitSynchronizeWizardPage.this.selectedBranches.get(mapping.getRepository());
                    CCombo combo = (CCombo)branchesEditor.getControl();
                    int index = branch == null ? 0 : combo.indexOf(branch);
                    return index;
                }
                String branch = (String)GitSynchronizeWizardPage.this.selectedBranches.get(element);
                CCombo combo = (CCombo)branchesEditor.getControl();
                int index = branch == null ? 0 : combo.indexOf(branch);
                return index;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof IProject) {
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)element));
                    Set refs = mapping.getRepository().getAllRefs().keySet();
                    branchesEditor.setItems(refs.toArray(new String[refs.size()]));
                } else {
                    Set refs = ((Repository)element).getAllRefs().keySet();
                    branchesEditor.setItems(refs.toArray(new String[refs.size()]));
                }
                return branchesEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        branchesColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProject) {
                    RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)element));
                    String branch = (String)GitSynchronizeWizardPage.this.selectedBranches.get(mapping.getRepository());
                    return branch == null ? "" : branch;
                }
                String branch = (String)GitSynchronizeWizardPage.this.selectedBranches.get(element);
                return branch == null ? "" : branch;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Repository) {
                    return !((Set)GitSynchronizeWizardPage.this.repositories.get(element)).isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Repository) {
                    return ((Set)GitSynchronizeWizardPage.this.repositories.get(parentElement)).toArray();
                }
                return new Object[0];
            }
        });
        final Object[] array = this.repositories.keySet().toArray();
        this.treeViewer.setInput((Object)array);
        this.treeViewer.setCheckedElements(array);
        repositoriesColumn.getColumn().pack();
        this.save();
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GitSynchronizeWizardPage.this.selectedRepositories.clear();
                GitSynchronizeWizardPage.this.selectedProjects.clear();
                GitSynchronizeWizardPage.this.save();
                if (event.getChecked()) {
                    GitSynchronizeWizardPage.this.setPageComplete(GitSynchronizeWizardPage.this.selectedBranches.size() == GitSynchronizeWizardPage.this.selectedRepositories.size());
                } else if (GitSynchronizeWizardPage.this.treeViewer.getCheckedElements().length == 0) {
                    GitSynchronizeWizardPage.this.setPageComplete(false);
                }
            }
        });
        Composite buttonsComposite = new Composite(composite, 0);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        Button selectAllBtn = new Button(buttonsComposite, 8);
        selectAllBtn.setText(UIText.GitBranchSynchronizeWizardPage_selectAll);
        selectAllBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GitSynchronizeWizardPage.this.treeViewer.setCheckedElements(array);
                GitSynchronizeWizardPage.this.save();
                GitSynchronizeWizardPage.this.setPageComplete(GitSynchronizeWizardPage.this.selectedBranches.size() == GitSynchronizeWizardPage.this.selectedRepositories.size());
            }
        });
        selectAllBtn.setLayoutData((Object)new GridData(4, 1, false, false));
        Button deselectAllBtn = new Button(buttonsComposite, 8);
        deselectAllBtn.setText(UIText.GitBranchSynchronizeWizardPage_deselectAll);
        deselectAllBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GitSynchronizeWizardPage.this.treeViewer.setCheckedElements(new Object[0]);
                GitSynchronizeWizardPage.this.selectedRepositories.clear();
                GitSynchronizeWizardPage.this.selectedProjects.clear();
                GitSynchronizeWizardPage.this.setPageComplete(false);
            }
        });
        deselectAllBtn.setLayoutData((Object)new GridData(4, 1, false, false));
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    public void dispose() {
        if (this.branchesImage != null) {
            this.branchesImage.dispose();
        }
        if (this.repositoryImage != null) {
            this.repositoryImage.dispose();
        }
        super.dispose();
    }

    private void save() {
        Object[] objectArray = this.treeViewer.getGrayedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object grayedElement = objectArray[n2];
            this.selectedRepositories.add((Repository)grayedElement);
            ++n2;
        }
        objectArray = this.treeViewer.getCheckedElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof Repository) {
                Repository repo = (Repository)checkedElement;
                if (this.selectedRepositories.add(repo)) {
                    this.selectedProjects.addAll((Collection<IProject>)this.repositories.get(repo));
                }
            } else {
                this.selectedProjects.add((IProject)checkedElement);
            }
            ++n2;
        }
    }

    Map<Repository, String> getSelectedBranches() {
        return this.selectedBranches;
    }

    Set<IProject> getSelectedProjects() {
        return this.selectedProjects;
    }
}

