/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.util.List;
import org.eclipse.egit.ui.internal.synchronize.SyncRepoEntity;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteSelectionCombo
extends Composite {
    private Label myRefLabel;
    private Combo refsCombo;
    private Combo remotesCombo;
    private final List<SyncRepoEntity> syncRepos;

    public RemoteSelectionCombo(Composite parent, List<SyncRepoEntity> syncRepos, String remoteLabel, String refLabel) {
        super(parent, 0);
        this.syncRepos = syncRepos;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.createRemoteGroup(remoteLabel);
        this.createRefsGroup(refLabel);
    }

    public void setEnabled(boolean enabled) {
        this.myRefLabel.setEnabled(enabled);
        this.refsCombo.setEnabled(enabled);
        this.remotesCombo.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void createRemoteGroup(String remoteLabel) {
        Composite remoteComposite = new Composite((Composite)this, 0);
        remoteComposite.setLayout((Layout)new GridLayout());
        remoteComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).create());
        this.myRefLabel = new Label(remoteComposite, 0);
        this.myRefLabel.setText(remoteLabel);
        this.remotesCombo = new Combo(remoteComposite, 0);
        this.remotesCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        for (SyncRepoEntity syncRepoEnt : this.syncRepos) {
            this.remotesCombo.add(syncRepoEnt.getName());
        }
        this.remotesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteSelectionCombo.this.fillRefsCombo();
            }
        });
    }

    private void createRefsGroup(String refLabel) {
        Composite refsComposite = new Composite((Composite)this, 0);
        refsComposite.setLayout((Layout)new GridLayout());
        refsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).create());
        Label ref = new Label(refsComposite, 0);
        ref.setText(refLabel);
        this.refsCombo = new Combo(refsComposite, 0);
        this.refsCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    public String getValue() {
        int refSelectedIndex = this.refsCombo.getSelectionIndex();
        int remoteSelectedIndex = this.remotesCombo.getSelectionIndex();
        if (remoteSelectedIndex < 0 && refSelectedIndex < 0) {
            return "";
        }
        return this.syncRepos.get(remoteSelectedIndex).getRefList().get(refSelectedIndex).getValue();
    }

    public void setDefaultValue(String remote, String ref) {
        int i = 0;
        while (i < this.syncRepos.size()) {
            if (this.syncRepos.get(i).getName().equals(remote)) break;
            ++i;
        }
        if (i == this.syncRepos.size()) {
            return;
        }
        this.remotesCombo.select(i);
        this.fillRefsCombo();
        List<SyncRepoEntity.SyncRefEntity> refList = this.syncRepos.get(i).getRefList();
        i = 0;
        while (i < refList.size()) {
            if (refList.get(i).getDescription().equals(ref)) break;
            ++i;
        }
        if (i == this.syncRepos.size()) {
            return;
        }
        this.refsCombo.select(i);
    }

    private void fillRefsCombo() {
        int selected = this.remotesCombo.getSelectionIndex();
        if (selected < 0) {
            return;
        }
        this.refsCombo.removeAll();
        SyncRepoEntity syncRepoEnt = this.syncRepos.get(selected);
        for (SyncRepoEntity.SyncRefEntity syncRefEnt : syncRepoEnt.getRefList()) {
            this.refsCombo.add(syncRefEnt.getDescription());
        }
        if (this.refsCombo.getItemCount() > 0) {
            this.refsCombo.select(0);
        }
    }
}

