/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.LocalResourceTypedElement;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jgit.lib.Repository;

public class GitLocalCompareInput
extends GitCompareInput {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public GitLocalCompareInput(Repository repo, ComparisonDataSource ancestorDataSource, ComparisonDataSource baseDataSource, ComparisonDataSource remoteDataSource, String gitPath) {
        super(repo, ancestorDataSource, baseDataSource, remoteDataSource, gitPath);
    }

    public ITypedElement getLeft() {
        String absoluteFilePath = String.valueOf(this.repo.getWorkTree().getAbsolutePath()) + "/" + this.gitPath;
        IFile file = ROOT.getFileForLocation((IPath)new Path(absoluteFilePath));
        if (file == null) {
            return new LocalNonWorkspaceTypedElement(absoluteFilePath);
        }
        return new LocalResourceTypedElement((IResource)file);
    }

    public ITypedElement getRight() {
        return CompareUtils.getFileCachedRevisionTypedElement(this.gitPath, this.repo);
    }

    public ITypedElement getAncestor() {
        return this.getRight();
    }
}

