/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GitChangeSetLabelProvider
extends SynchronizationLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    private LabelProvider delegateLabelProvider;

    protected ILabelProvider getDelegateLabelProvider() {
        if (this.delegateLabelProvider == null) {
            this.delegateLabelProvider = new DelegateLabelProvider();
        }
        return this.delegateLabelProvider;
    }

    public StyledString getStyledText(Object element) {
        String rawText = this.getText(element);
        if (element.getClass().equals(GitModelCommit.class)) {
            StyledString string = new StyledString(rawText);
            GitModelCommit commit = (GitModelCommit)((Object)element);
            String format = " [" + this.getAbbreviatedId(commit) + "]";
            string.append(format, StyledString.DECORATIONS_STYLER);
            return string;
        }
        return new StyledString(rawText);
    }

    private String getAbbreviatedId(GitModelCommit commit) {
        AbbreviatedObjectId shortId;
        block5: {
            RevCommit remoteCommit = commit.getBaseCommit();
            ObjectReader reader = commit.getRepository().newObjectReader();
            ObjectId commitId = remoteCommit.getId();
            try {
                try {
                    shortId = reader.abbreviate((AnyObjectId)commitId, 6);
                }
                catch (IOException e) {
                    shortId = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());
                    Activator.logError((String)e.getMessage(), (Throwable)e);
                    reader.release();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                reader.release();
                throw throwable;
            }
            reader.release();
        }
        return shortId.name();
    }

    private static class DelegateLabelProvider
    extends LabelProvider {
        private final ResourceManager fImageCache = new LocalResourceManager(JFaceResources.getResources());

        private DelegateLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof GitModelObject) {
                return ((GitModelObject)((Object)element)).getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof GitModelBlob) {
                Object adapter = ((GitModelBlob)((Object)element)).getAdapter(IResource.class);
                return workbenchLabelProvider.getImage(adapter);
            }
            if (element instanceof GitModelTree) {
                Object adapter = ((GitModelTree)((Object)element)).getAdapter(IResource.class);
                return workbenchLabelProvider.getImage(adapter);
            }
            if (element instanceof GitModelCommit || element instanceof GitModelCache || element instanceof GitModelWorkingTree) {
                return this.fImageCache.createImage(UIIcons.CHANGESET);
            }
            if (element instanceof GitModelRepository) {
                return this.fImageCache.createImage(UIIcons.REPOSITORY);
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.fImageCache.dispose();
            super.dispose();
        }
    }
}

