/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.File;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitModelBlob
extends GitModelCommit {
    private final IPath location;
    private final ObjectId baseId;
    private final ObjectId remoteId;
    private final ObjectId ancestorId;
    private static final GitModelObject[] empty = new GitModelObject[0];
    private GitCompareInput compareInput;
    protected final String gitPath;

    public GitModelBlob(GitModelObjectContainer parent, RevCommit commit, RevCommit ancestorCommit, ObjectId ancestorId, ObjectId baseId, ObjectId remoteId, IPath location) throws IOException {
        super(parent, commit, ancestorCommit, parent.getKind() & 0xC);
        this.baseId = baseId;
        this.remoteId = remoteId;
        this.ancestorId = ancestorId;
        this.location = location;
        this.gitPath = Repository.stripWorkDir((File)this.getRepository().getWorkTree(), (File)this.getLocation().toFile());
    }

    public GitModelObject[] getChildren() {
        return empty;
    }

    public String getName() {
        return this.location.lastSegment();
    }

    public IPath getLocation() {
        return this.location;
    }

    public boolean isContainer() {
        return false;
    }

    public ITypedElement getAncestor() {
        this.createCompareInput();
        return this.compareInput.getAncestor();
    }

    public ITypedElement getLeft() {
        this.createCompareInput();
        return this.compareInput.getLeft();
    }

    public ITypedElement getRight() {
        this.createCompareInput();
        return this.compareInput.getRight();
    }

    public int getKind() {
        if (this.kind != 4 && this.kind != 8) {
            return this.kind;
        }
        int changeKind = ObjectId.zeroId().equals((AnyObjectId)this.remoteId) ? 2 : (ObjectId.zeroId().equals((AnyObjectId)this.ancestorId) ? 1 : 3);
        this.kind |= changeKind;
        return this.kind;
    }

    public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.createCompareInput();
        this.compareInput.prepareInput(configuration, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitModelBlob) {
            boolean equalsRemoteId;
            GitModelBlob objBlob = (GitModelBlob)((Object)obj);
            ObjectId objRemoteId = objBlob.remoteId;
            if (objRemoteId != null) {
                equalsRemoteId = objRemoteId.equals((AnyObjectId)this.remoteId);
            } else {
                boolean bl = equalsRemoteId = this.baseCommit == null;
            }
            return objBlob.baseId.equals((AnyObjectId)this.baseId) && equalsRemoteId;
        }
        return false;
    }

    public int hashCode() {
        int result = this.baseId.hashCode();
        if (this.remoteId != null) {
            result ^= this.remoteId.hashCode();
        }
        return result;
    }

    private void createCompareInput() {
        if (this.compareInput == null) {
            ComparisonDataSource baseData = new ComparisonDataSource(this.baseCommit, this.baseId);
            ComparisonDataSource remoteData = new ComparisonDataSource(this.remoteCommit, this.remoteId);
            ComparisonDataSource ancestorData = new ComparisonDataSource(this.ancestorCommit, this.ancestorId);
            this.compareInput = this.getCompareInput(baseData, remoteData, ancestorData);
        }
    }

    protected GitCompareInput getCompareInput(ComparisonDataSource baseData, ComparisonDataSource remoteData, ComparisonDataSource ancestorData) {
        return new GitCompareInput(this.getRepository(), ancestorData, baseData, remoteData, this.gitPath);
    }
}

