/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitModelCacheTree
extends GitModelTree {
    private final GitModelCache.FileModelFactory factory;
    private final Map<String, GitModelObject> cacheTreeMap;

    public GitModelCacheTree(GitModelObjectContainer parent, RevCommit commit, ObjectId repoId, ObjectId cacheId, IPath location, GitModelCache.FileModelFactory factory) throws IOException {
        super(parent, commit, null, repoId, repoId, cacheId, location);
        this.factory = factory;
        this.cacheTreeMap = new HashMap<String, GitModelObject>();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    void addChild(ObjectId repoId, ObjectId cacheId, String path) throws IOException {
        int firstSlash = path.indexOf("/");
        String pathKey = firstSlash > -1 ? path.substring(0, firstSlash) : path;
        IPath fullPath = this.getLocation().append(pathKey);
        if (path.contains("/")) {
            GitModelCacheTree cacheEntry = (GitModelCacheTree)this.cacheTreeMap.get(pathKey);
            if (cacheEntry == null) {
                cacheEntry = new GitModelCacheTree(this, this.baseCommit, repoId, cacheId, fullPath, this.factory);
                this.cacheTreeMap.put(pathKey, cacheEntry);
            }
            cacheEntry.addChild(repoId, cacheId, path.substring(firstSlash + 1));
        } else {
            this.cacheTreeMap.put(pathKey, this.factory.createFileModel(this, this.baseCommit, repoId, cacheId, fullPath));
        }
    }

    protected GitModelObject[] getChildrenImpl() {
        Collection<GitModelObject> values = this.cacheTreeMap.values();
        return values.toArray(new GitModelObject[values.size()]);
    }
}

