/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;

public abstract class GitModelObjectContainer
extends GitModelObject
implements ISynchronizationCompareInput {
    protected int kind = -1;
    private String name;
    private GitModelObject[] children;
    protected final RevCommit baseCommit;
    protected final RevCommit remoteCommit;

    protected GitModelObjectContainer(GitModelObject parent, RevCommit commit, int direction) throws IOException {
        super(parent);
        this.kind = direction;
        this.baseCommit = commit;
        RevCommit[] parents = this.baseCommit.getParents();
        this.remoteCommit = parents != null && parents.length > 0 ? this.baseCommit.getParent(0) : null;
    }

    public Image getImage() {
        return null;
    }

    public RevCommit getBaseCommit() {
        return this.baseCommit;
    }

    public RevCommit getRemoteCommit() {
        return this.remoteCommit;
    }

    public int getKind() {
        if (this.kind == -1 || this.kind == 4 || this.kind == 8) {
            this.calculateKind();
        }
        return this.kind;
    }

    public GitModelObject[] getChildren() {
        if (this.children == null) {
            this.children = this.getChildrenImpl();
        }
        return this.children;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.baseCommit.getShortMessage();
        }
        return this.name;
    }

    public IProject[] getProjects() {
        return this.getParent().getProjects();
    }

    public abstract IPath getLocation();

    public ITypedElement getAncestor() {
        return null;
    }

    public ITypedElement getLeft() {
        return null;
    }

    public ITypedElement getRight() {
        return null;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void copy(boolean leftToRight) {
    }

    public boolean isContainer() {
        return true;
    }

    public SaveableComparison getSaveable() {
        return null;
    }

    public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
    }

    public String getFullPath() {
        return this.getLocation().toPortableString();
    }

    public boolean isCompareInputFor(Object object) {
        return false;
    }

    protected abstract GitModelObject[] getChildrenImpl();

    protected GitModelObject getModelObject(TreeWalk tw, RevCommit ancestorCommit, int ancestorNth, int baseNth, int actualNth) throws IOException {
        Path path = new Path(this.getLocation() + "/" + tw.getPathString());
        ObjectId objBaseId = baseNth > -1 ? tw.getObjectId(baseNth) : ObjectId.zeroId();
        ObjectId objRemoteId = tw.getObjectId(actualNth);
        ObjectId objAncestorId = ancestorNth > -1 ? tw.getObjectId(ancestorNth) : ObjectId.zeroId();
        int objectType = tw.getFileMode(actualNth).getObjectType();
        if (objectType == -1) {
            objectType = tw.getFileMode(baseNth).getObjectType();
        }
        if (objectType == -1 && ancestorNth > -1) {
            objectType = tw.getFileMode(ancestorNth).getObjectType();
        }
        if (objectType == 3) {
            return new GitModelBlob(this, this.getBaseCommit(), ancestorCommit, objAncestorId, objBaseId, objRemoteId, (IPath)path);
        }
        if (objectType == 2) {
            return new GitModelTree(this, this.getBaseCommit(), ancestorCommit, objAncestorId, objBaseId, objRemoteId, (IPath)path);
        }
        return null;
    }

    private void calculateKind() {
        ObjectId remote;
        ObjectId objectId = remote = this.remoteCommit != null ? this.remoteCommit.getId() : ObjectId.zeroId();
        this.kind = remote.equals((AnyObjectId)ObjectId.zeroId()) ? (this.kind |= 1) : (this.baseCommit.equals((AnyObjectId)ObjectId.zeroId()) ? (this.kind |= 2) : (this.kind |= 3));
    }
}

