/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitModelRepository
extends GitModelObject {
    private final Repository repo;
    private final RevCommit srcRev;
    private final RevCommit dstRev;
    private final IProject[] projects;
    private final boolean includeLocal;
    private GitModelObject[] childrens;
    private IPath location;

    public GitModelRepository(GitSynchronizeData data) throws MissingObjectException, IOException {
        super(null);
        this.repo = data.getRepository();
        this.includeLocal = data.shouldIncludeLocal();
        Set projectSet = data.getProjects();
        this.projects = projectSet.toArray(new IProject[projectSet.size()]);
        this.srcRev = data.getSrcRevCommit();
        this.dstRev = data.getDstRevCommit();
    }

    public GitModelObject[] getChildren() {
        if (this.childrens == null) {
            this.getChildrenImpl();
        }
        return this.childrens;
    }

    public String getName() {
        return this.repo.getWorkTree().toString();
    }

    public IProject[] getProjects() {
        return this.projects;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public ObjectId getSrcRev() {
        return this.srcRev;
    }

    public ObjectId getDstRev() {
        return this.dstRev;
    }

    public IPath getLocation() {
        if (this.location == null) {
            this.location = new Path(this.repo.getWorkTree().toString());
        }
        return this.location;
    }

    public boolean isContainer() {
        return true;
    }

    private void getChildrenImpl() {
        RevWalk rw = new RevWalk(this.repo);
        RevFlag localFlag = rw.newFlag("local");
        RevFlag remoteFlag = rw.newFlag("remote");
        RevFlagSet allFlags = new RevFlagSet();
        allFlags.add(localFlag);
        allFlags.add(remoteFlag);
        rw.carry((Collection)allFlags);
        ArrayList<GitModelObjectContainer> result = new ArrayList<GitModelObjectContainer>();
        rw.setRetainBody(true);
        try {
            RevCommit srcCommit = rw.parseCommit((AnyObjectId)this.srcRev);
            srcCommit.add(localFlag);
            rw.markStart(srcCommit);
            RevCommit dstCommit = rw.parseCommit((AnyObjectId)this.dstRev);
            dstCommit.add(remoteFlag);
            rw.markStart(dstCommit);
            for (RevCommit nextCommit : rw) {
                if (nextCommit.hasAll(allFlags)) break;
                if (nextCommit.has(localFlag)) {
                    result.add(new GitModelCommit(this, nextCommit, 8));
                    continue;
                }
                if (!nextCommit.has(remoteFlag)) continue;
                result.add(new GitModelCommit(this, nextCommit, 4));
            }
            if (this.includeLocal) {
                GitModelWorkingTree gitModelWorkingTree;
                GitModelCache gitModelCache = new GitModelCache(this, srcCommit);
                if (gitModelCache.getChildren().length > 0) {
                    result.add(gitModelCache);
                }
                if ((gitModelWorkingTree = new GitModelWorkingTree(this, srcCommit)).getChildren().length > 0) {
                    result.add(gitModelWorkingTree);
                }
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        this.childrens = result.toArray(new GitModelObjectContainer[result.size()]);
    }
}

