/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;

public class GitModelRoot {
    private final GitSynchronizeDataSet gsds;
    private GitModelObject[] children;

    public GitModelRoot(GitSynchronizeDataSet gsds) {
        this.gsds = gsds;
    }

    public GitSynchronizeDataSet getGsds() {
        return this.gsds;
    }

    public GitModelObject[] getChildren() {
        if (this.children == null) {
            this.children = this.getChildrenImpl();
        }
        return this.children;
    }

    private GitModelObject[] getChildrenImpl() {
        ArrayList<GitModelObject> restult = new ArrayList<GitModelObject>();
        try {
            if (this.gsds.size() == 1) {
                GitSynchronizeData gsd = (GitSynchronizeData)this.gsds.iterator().next();
                GitModelRepository repoModel = new GitModelRepository(gsd);
                GitModelObject[] gitModelObjectArray = repoModel.getChildren();
                int n = gitModelObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GitModelObject obj = gitModelObjectArray[n2];
                    restult.add(obj);
                    ++n2;
                }
            } else {
                for (GitSynchronizeData data : this.gsds) {
                    restult.add(new GitModelRepository(data));
                }
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        return restult.toArray(new GitModelObject[restult.size()]);
    }
}

