/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingFile;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitModelWorkingTree
extends GitModelCache {
    public GitModelWorkingTree(GitModelObject parent, RevCommit commit) throws IOException {
        super(parent, commit, new GitModelCache.FileModelFactory(){

            public GitModelBlob createFileModel(GitModelObjectContainer modelParent, RevCommit modelCommit, ObjectId repoId, ObjectId cacheId, IPath location) throws IOException {
                return new GitModelWorkingFile(modelParent, modelCommit, repoId, location);
            }
        });
    }

    public String getName() {
        return UIText.GitModelWorkingTree_workingTree;
    }

    protected TreeWalk createAndConfigureTreeWalk() throws IOException {
        TreeWalk tw = this.createTreeWalk();
        tw.setRecursive(true);
        Repository repo = this.getRepository();
        int ftIndex = tw.addTree((AbstractTreeIterator)new FileTreeIterator(repo));
        int dirCacheIteratorNth = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
        IndexDiffFilter idf = new IndexDiffFilter(dirCacheIteratorNth, ftIndex, true);
        tw.setFilter((TreeFilter)idf);
        return tw;
    }
}

