/**
 * Copyright (c) 2004 - 2010 Eike Stepper (Berlin, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.spi.common.model;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;

import org.eclipse.net4j.util.lifecycle.ILifecycle;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;

import java.util.Set;

/**
 * @author Eike Stepper
 * @since 2.0
 */
public interface InternalCDOPackageRegistry extends CDOPackageRegistry, ILifecycle
{
  public MetaInstanceMapper getMetaInstanceMapper();

  public void setReplacingDescriptors(boolean replacingDescriptors);

  public PackageProcessor getPackageProcessor();

  public void setPackageProcessor(PackageProcessor packageProcessor);

  public PackageLoader getPackageLoader();

  public void setPackageLoader(PackageLoader packageLoader);

  public Object basicPut(String nsURI, Object value);

  public void putPackageUnit(InternalCDOPackageUnit packageUnit);

  /**
   * @since 3.0
   */
  public InternalCDOPackageUnit getPackageUnit(String id);

  public InternalCDOPackageUnit getPackageUnit(EPackage ePackage);

  public InternalCDOPackageUnit[] getPackageUnits();

  /**
   * @since 3.0
   */
  public InternalCDOPackageUnit[] getPackageUnits(long startTime, long endTime);

  public InternalCDOPackageInfo getPackageInfo(EPackage ePackage);

  public InternalCDOPackageInfo[] getPackageInfos();

  public EPackage[] getEPackages();

  /**
   * @since 3.0
   */
  public Set<String> getAllKeys();

  /**
   * @since 3.0
   */
  public Object getWithDelegation(String nsURI, boolean resolve);

  /**
   * @author Eike Stepper
   */
  public interface PackageProcessor
  {
    public Object processPackage(Object value);
  }

  /**
   * @author Eike Stepper
   */
  public interface PackageLoader
  {
    public EPackage[] loadPackages(CDOPackageUnit packageUnit);
  }

  /**
   * @author Eike Stepper
   */
  public interface MetaInstanceMapper
  {
    public Set<Entry<CDOID, InternalEObject>> getEntrySet();

    public InternalEObject lookupMetaInstance(CDOID id);

    public CDOID lookupMetaInstanceID(InternalEObject metaInstance);

    public CDOIDMetaRange mapMetaInstances(EPackage ePackage);

    public void mapMetaInstances(EPackage ePackage, CDOIDMetaRange metaIDRange);

    public void mapMetaInstances(MetaInstanceMapper source);

    public void remapMetaInstanceID(CDOID oldID, CDOID newID);
  }
}
